// ignore_for_file: prefer_const_constructors, non_constant_identifier_names, deprecated_member_use, must_be_immutable, unnecessary_brace_in_string_interps, unused_local_variable, unused_import, invalid_use_of_protected_member, avoid_print

import 'dart:ui' as ui;
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';
import 'package:get/get.dart';
import 'package:nlytical_app/auth/splash.dart';
import 'package:nlytical_app/controllers/user_controllers/filter_contro.dart';
import 'package:nlytical_app/controllers/user_controllers/home_contro.dart';
import 'package:nlytical_app/controllers/user_controllers/like_contro.dart';
import 'package:nlytical_app/controllers/user_controllers/nearby_contro.dart';
import 'package:nlytical_app/User/screens/explore/filter.dart';
import 'package:nlytical_app/User/screens/homeScreen/details.dart';
import 'package:nlytical_app/User/screens/shimmer_loader/favourite_loader.dart';
import 'package:nlytical_app/User/screens/shimmer_loader/nearby_loader.dart';
import 'package:nlytical_app/shared_preferences/prefrences_key.dart';
import 'package:nlytical_app/shared_preferences/shared_prefkey.dart';
import 'package:nlytical_app/utils/assets.dart';
import 'package:nlytical_app/utils/colors.dart';
import 'package:nlytical_app/utils/comman_screen.dart';
import 'package:nlytical_app/utils/comman_widgets.dart';
import 'package:nlytical_app/utils/flexible_space.dart';
import 'package:nlytical_app/utils/global.dart';
import 'package:nlytical_app/utils/global_fonts.dart';
import 'package:nlytical_app/utils/size_config.dart';
import 'package:geocoding/geocoding.dart';
import 'package:geolocator/geolocator.dart';
import 'package:shimmer/shimmer.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:nlytical_app/utils/common_widgets.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

class Explore extends StatefulWidget {
  const Explore({super.key});

  @override
  State<Explore> createState() => ExploreState();
}

class ExploreState extends State<Explore> {
  NearbyContro nearcontro = Get.find();
  LikeContro likecontro = Get.find();
  FilterContro filtercontro = Get.find();
  HomeContro homecontro = Get.find();

  // int page = 1;
  bool isLoadingMore = false;
  // ItemScrollController _scrollController1 = ItemScrollController();
  final scrollController = ScrollController();

  @override
  void initState() {
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      print("explore page open");
      filtercontro.scrollControllerlocation = ScrollController();
      debugPrint(
        "lat1****** ${SharedPrefs.getString(SharedPreferencesKey.LATTITUDE)}",
      );
      debugPrint(
        "lng2***** ${SharedPrefs.getString(SharedPreferencesKey.LONGITUDE)}",
      );
      nearcontro
          .nearbyApi(
            latitudee: SharedPrefs.getString(SharedPreferencesKey.LATTITUDE),
            longitudee: SharedPrefs.getString(SharedPreferencesKey.LONGITUDE),
            page: "1",
          )
          .then((_) {
            nearcontro.currentpage.value = 1;
            addMarker();
          });
      scrollController.addListener(_scrollListener);
      if (mounted) {
        setState(() {});
      }
    });
  }

  void _scrollListener() async {
    if (scrollController.position.pixels >=
            scrollController.position.maxScrollExtent &&
        nearcontro.hasMoreData.value &&
        !isLoadingMore) {
      try {
        nearcontro.currentpage.value++;
        await fetchRestaurants(); // Fetch data for the next page
      } catch (e) {
        print("Error fetching restaurants: $e");
      } finally {
        setState(() {
          isLoadingMore = false;
        });
      }
    }
  }

  Future<void> fetchRestaurants() async {
    try {
      setState(() {
        isLoadingMore = true;
      });
      print('Fetching page: ${nearcontro.currentpage}'); // Log the page number
      await nearcontro.nearbyApi(
        latitudee: SharedPrefs.getString(SharedPreferencesKey.LATTITUDE),
        longitudee: SharedPrefs.getString(SharedPreferencesKey.LONGITUDE),
        page: nearcontro.currentpage.toString(),
      );
      setState(() {
        isLoadingMore = false;
      });
    } catch (error) {
      setState(() {
        isLoadingMore = false;
      });
      print("Error fetching data: $error");
    }
  }

  @override
  dispose() {
    scrollController.dispose();
    filtercontro.isnavfilter.value = false;
    super.dispose();
  }

  Position? currentPosition;

  @override
  Widget build(BuildContext context) {
    return DefaultTabController(
      length: 2,
      initialIndex: 0,
      child: Scaffold(
        backgroundColor:
            themeContro.isLightMode.value
                ? Appcolors.white
                : Appcolors.darkMainBlack,
        appBar: PreferredSize(
          preferredSize: Size.fromHeight(60),
          child: AppBar(
            centerTitle: true,
            title: Text(
              languageController.textTranslate("Explore"),
              style: poppinsFont(20, Appcolors.white, FontWeight.w500),
            ),
            flexibleSpace: flexibleSpace(),
            backgroundColor: Appcolors.appBgColor.transparent,
            shadowColor: Appcolors.appBgColor.transparent,
            elevation: 0,
            automaticallyImplyLeading: false,
            actions: [
              nearcontro.isnear.value || nearcontro.nearbylist.isEmpty
                  ? SizedBox.shrink()
                  : GestureDetector(
                    onTap: () {
                      // openBottomForfilter(context);
                      Get.to(
                        () => Filter(
                          catid:
                              nearcontro
                                  .nearbymodel
                                  .value!
                                  .nearbyService![0]
                                  .categoryId
                                  .toString(),
                        ),
                      )!.then((_) {
                        setState(() {
                          print(
                            "<<selectedCategories>>:${filtercontro.selectedCategories}",
                          );
                          print(
                            "<<selectedSubCate>>:${filtercontro.selectedSubCate}",
                          );
                        });
                      });
                    },
                    child: Image.asset(
                      'assets/images/menu1.png',
                      color: Appcolors.white,
                      height: 24,
                    ),
                  ).paddingOnly(right: 20),
            ],
          ),
        ),
        body: Container(
          width: Get.width,
          decoration: BoxDecoration(
            color: Appcolors.appPriSecColor.appPrimblue,
          ),
          child: Container(
            width: Get.width,
            decoration: BoxDecoration(
              color:
                  themeContro.isLightMode.value
                      ? Appcolors.white
                      : Appcolors.darkMainBlack,
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(32),
                topRight: Radius.circular(32),
              ),
            ),
            child: Column(
              children: [
                sizeBoxHeight(12),
                Container(
                  height: 50,
                  width: Get.width,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(17),
                    boxShadow: [
                      BoxShadow(
                        offset: Offset(1, 1),
                        blurRadius: 6.7,
                        color: Appcolors.black.withValues(alpha: 0.14),
                      ),
                    ],
                  ),
                  child: Column(children: [profiletab()]),
                ).paddingSymmetric(horizontal: 10),
                Obx(() {
                  return (nearcontro.isnear.value)
                      ? SizedBox.shrink()
                      : filtercontro.isnavfilter.value
                      ? Column(
                        children: [
                          sizeBoxHeight(15),
                          filter_clear(),
                          sizeBoxHeight(15),
                        ],
                      )
                      : SizedBox.shrink();
                }),
                Expanded(
                  child: TabBarView(
                    physics: NeverScrollableScrollPhysics(),
                    children: [
                      Obx(() {
                        return (nearcontro.isnear.value)
                            ? nearbyListLoader(context)
                            : Obx(
                              () =>
                                  filtercontro.isnavfilter.value
                                      ? filterlisting()
                                      : listing(),
                            );
                      }),
                      Obx(() {
                        return nearcontro.isnear.value
                            ? Center(
                              child: CupertinoActivityIndicator(
                                color: Appcolors.appPriSecColor.appPrimblue,
                              ),
                            )
                            : filtercontro.isnavfilter.value
                            ? SharedPrefs.getString(
                                  SharedPreferencesKey.LATTITUDE,
                                ).isEmpty
                                ? explore_empty()
                                : location_()
                            : SharedPrefs.getString(
                              SharedPreferencesKey.LATTITUDE,
                            ).isEmpty
                            ? explore_empty()
                            : location();
                      }),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget profiletab() {
    return Expanded(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            decoration: BoxDecoration(
              color:
                  themeContro.isLightMode.value
                      ? Appcolors.white
                      : Appcolors.darkGray,
              borderRadius: BorderRadius.circular(17),
              boxShadow: [
                BoxShadow(
                  color:
                      themeContro.isLightMode.value
                          ? Appcolors.grey100
                          : Appcolors.darkShadowColor,
                  blurRadius: 0.0,
                  spreadRadius: 0.0,
                  offset: const Offset(
                    1.0,
                    1.0,
                  ), // shadow direction: bottom right
                ),
              ],
            ),
            child: TabBar(
              // controller: _tabController,
              indicator: UnderlineTabIndicator(
                borderSide: BorderSide(
                  width: 1.0,
                  color: Appcolors.appBgColor.transparent,
                ),
                insets: EdgeInsets.symmetric(horizontal: 2.0),
              ),
              dividerColor: Appcolors.appBgColor.transparent,
              labelColor: Appcolors.appPriSecColor.appPrimblue,
              unselectedLabelColor: Appcolors.grey,
              unselectedLabelStyle: TextStyle(
                color: Appcolors.grey,
                fontSize: 16,
                fontWeight: FontWeight.w600,
                fontFamily: 'Poppins',
              ),
              labelStyle: TextStyle(
                color: Appcolors.grey,
                fontSize: 16,
                fontWeight: FontWeight.w600,
                fontFamily: 'Poppins',
              ),
              indicatorColor: Appcolors.appPriSecColor.appPrimblue,
              indicatorSize: TabBarIndicatorSize.label,

              tabs: [
                Tab(
                  child: Text(
                    '   ${languageController.textTranslate("Listing")}   ',
                  ),
                ),
                Tab(
                  child: Text(
                    '    ${languageController.textTranslate("Location")}    ',
                  ),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  // -----------------------------------------------------------filter list ------------------------------------------------------------

  Widget filterlisting() {
    if (filtercontro.isfilter.value && filtercontro.currentpage.value == 1) {
      return CircularProgressIndicator();
    } else if (filtercontro.serviceFilte.isEmpty) {
      return explore_empty();
    }
    return GridView.builder(
      itemCount:
          filtercontro.serviceFilte.length +
          (isLoadingMore || !nearcontro.hasMoreData.value ? 1 : 0),
      physics: AlwaysScrollableScrollPhysics(),
      padding: EdgeInsets.zero,
      controller: scrollController,
      shrinkWrap: true,
      gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
        crossAxisCount: 2, // 2 items in a row
        childAspectRatio: 0.58, // Adjust for image and text ratio
        crossAxisSpacing: 10,
        mainAxisSpacing: 10,
      ),
      itemBuilder: (context, index) {
        if (index < filtercontro.serviceFilte.length) {
          return CommanScreen(
            lat: filtercontro.filtermodel.value!.serviceFilter![index].lat,
            lon: filtercontro.filtermodel.value!.serviceFilter![index].lon,
            storeImages:
                filtercontro
                    .filtermodel
                    .value!
                    .serviceFilter![index]
                    .serviceImages![0]
                    .toString(),
            sname:
                filtercontro
                    .filtermodel
                    .value!
                    .serviceFilter![index]
                    .serviceName!
                    .capitalizeFirst
                    .toString(),
            cname:
                filtercontro
                    .filtermodel
                    .value!
                    .serviceFilter![index]
                    .categoryName!
                    .capitalizeFirst
                    .toString(),
            vname:
                filtercontro.filtermodel.value!.serviceFilter![index].firstName
                    .toString(),
            vendorImages:
                filtercontro.filtermodel.value!.serviceFilter![index].image
                    .toString(),
            isfeatured:
                filtercontro
                    .filtermodel
                    .value!
                    .serviceFilter![index]
                    .isFeatured!,
            ratingCount:
                filtercontro
                        .filtermodel
                        .value!
                        .serviceFilter![index]
                        .averageReviewStar!
                        .isEmpty
                    ? 0.00
                    : double.parse(
                      filtercontro
                          .filtermodel
                          .value!
                          .serviceFilter![index]
                          .averageReviewStar!,
                    ),
            avrageReview:
                filtercontro
                    .filtermodel
                    .value!
                    .serviceFilter![index]
                    .totalReviewCount!
                    .toString(),
            isLike:
                SharedPrefs.getString(
                      SharedPreferencesKey.LOGGED_IN_USERID,
                    ).isEmpty
                    ? 0
                    : filtercontro
                        .filtermodel
                        .value!
                        .serviceFilter![index]
                        .isLike!,
            onTaplike: () {
              if (SharedPrefs.getString(
                SharedPreferencesKey.LOGGED_IN_USERID,
              ).isEmpty) {
                snackBar('Please login to like this service');
                loginPopup(bottomsheetHeight: Get.height * 0.95);
              } else {
                likecontro.likeApi(
                  filtercontro.filtermodel.value!.serviceFilter![index].id
                      .toString(),
                );

                // Toggle the isLike value for the UI update (you may want to update this dynamically after the API call succeeds)
                setState(() {
                  filtercontro.filtermodel.value!.serviceFilter![index].isLike =
                      filtercontro
                                  .filtermodel
                                  .value!
                                  .serviceFilter![index]
                                  .isLike ==
                              0
                          ? 1
                          : 0;
                });
              }
            },
            onTapstore: () {
              Get.to(
                Details(
                  serviceid:
                      filtercontro.filtermodel.value!.serviceFilter![index].id
                          .toString(),
                  isVendorService: false,
                ),
                transition: Transition.rightToLeft,
              );
            },
            location:
                filtercontro.filtermodel.value!.serviceFilter![index].address
                    .toString(),
            price:
                filtercontro
                    .filtermodel
                    .value!
                    .serviceFilter![index]
                    .priceRange!,
          );
        } else {
          return Shimmer.fromColors(
            baseColor: Appcolors.grey300,
            highlightColor: Appcolors.grey100,
            child: Card(
              color: Appcolors.white,
              shape: const RoundedRectangleBorder(
                // side: BorderSide(color: Appcolors.grey100),
                borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(15),
                  topRight: Radius.circular(15),
                  bottomLeft: Radius.circular(9),
                  bottomRight: Radius.circular(9),
                ),
              ),
              child: Stack(
                children: [
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.stretch,
                    children: [
                      const ClipRRect(
                        borderRadius: BorderRadius.only(
                          topLeft: Radius.circular(10),
                          topRight: Radius.circular(10),
                          bottomLeft: Radius.circular(22),
                          bottomRight: Radius.circular(22),
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          );
        }
      },
    ).paddingSymmetric(horizontal: 15, vertical: 5);
  }

  Widget filter_clear() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        SizedBox(
          width: 270,
          height: 30,
          child: SingleChildScrollView(
            scrollDirection: Axis.horizontal,
            child: Row(
              children: [
                filtercontro.selectedCategories.isNotEmpty &&
                        filtercontro.selectedCategories.first.isNotEmpty
                    ? ListView.builder(
                      shrinkWrap: true,
                      scrollDirection: Axis.horizontal,
                      itemCount: filtercontro.selectedCategories.value.length,
                      itemBuilder: (context, index) {
                        return Padding(
                          padding: const EdgeInsets.symmetric(horizontal: 5),
                          child: Container(
                            height: 30,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(6),
                              color: Appcolors.white,
                              border: Border.all(
                                color: Appcolors.appPriSecColor.appPrimblue,
                              ),
                            ),
                            child: Center(
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  sizeBoxWidth(10),
                                  SizedBox(
                                    child: label(
                                      filtercontro
                                              .selectedCategories
                                              .value
                                              .isNotEmpty
                                          ? filtercontro
                                              .selectedCategories[index] // Convert list to a string
                                          : 'No Category Selected',
                                      fontSize: 10,
                                      maxLines: 2,
                                      textColor: Appcolors.black,
                                      fontWeight: FontWeight.w400,
                                    ),
                                  ),
                                  sizeBoxWidth(10),
                                ],
                              ),
                            ),
                          ),
                        );
                      },
                    )
                    : SizedBox.shrink(),
                filtercontro.selectedSubCate.isNotEmpty &&
                        filtercontro.selectedSubCate.first.isNotEmpty
                    ? ListView.builder(
                      shrinkWrap: true,
                      scrollDirection: Axis.horizontal,
                      itemCount: filtercontro.selectedSubCate.value.length,
                      itemBuilder: (context, index) {
                        return Padding(
                          padding: const EdgeInsets.symmetric(horizontal: 5),
                          child: Container(
                            height: 30,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(6),
                              color: Appcolors.white,
                              border: Border.all(
                                color: Appcolors.appPriSecColor.appPrimblue,
                              ),
                            ),
                            child: Center(
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  sizeBoxWidth(10),
                                  SizedBox(
                                    child: label(
                                      filtercontro
                                              .selectedSubCate
                                              .value
                                              .isNotEmpty
                                          ? filtercontro
                                              .selectedSubCate[index] // Convert list to a string
                                          : 'No Subcategory Selected',
                                      fontSize: 10,
                                      maxLines: 2,
                                      textColor: Appcolors.black,
                                      fontWeight: FontWeight.w400,
                                    ),
                                  ),
                                  sizeBoxWidth(10),
                                ],
                              ),
                            ),
                          ),
                        );
                      },
                    )
                    : SizedBox.shrink(),
                filtercontro.selectedSubCate.isNotEmpty &&
                        filtercontro.selectedSubCate.first.isNotEmpty
                    ? sizeBoxHeight(5)
                    : SizedBox.shrink(),
                filtercontro.selectedRating.value > 0
                    ? Container(
                      height: 30,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(6),
                        color: Appcolors.white,
                        border: Border.all(
                          color: Appcolors.appPriSecColor.appPrimblue,
                        ),
                      ),
                      child: Center(
                        child: label(
                          filtercontro.selectedRating.value > 0
                              ? '${filtercontro.selectedRating.value} Star'
                              : 'No Rating Selected',
                          fontSize: 10,
                          textColor: Appcolors.black,
                          fontWeight: FontWeight.w400,
                        ).paddingSymmetric(horizontal: 5),
                      ),
                    )
                    : SizedBox.shrink(),
                filtercontro.selectedRating.value > 0
                    ? sizeBoxWidth(10)
                    : SizedBox.shrink(),
                filtercontro.selectedPrice.value > 0
                    ? Container(
                      height: 30,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(6),
                        color: Appcolors.white,
                        border: Border.all(
                          color: Appcolors.appPriSecColor.appPrimblue,
                        ),
                      ),
                      child: Center(
                        child: label(
                          '${filtercontro.selectedPrice.value} Price',
                          fontSize: 10,
                          textColor: Appcolors.black,
                          fontWeight: FontWeight.w400,
                        ),
                      ).paddingSymmetric(horizontal: 5),
                    )
                    : SizedBox.shrink(),
                filtercontro.selectedType.isNotEmpty &&
                        filtercontro.selectedType.first.isNotEmpty
                    ? sizeBoxWidth(10)
                    : SizedBox.shrink(),
                filtercontro.selectedType.isNotEmpty &&
                        filtercontro.selectedType.first.isNotEmpty
                    ? ListView.builder(
                      shrinkWrap: true,
                      scrollDirection: Axis.horizontal,
                      itemCount: filtercontro.selectedType.value.length,
                      itemBuilder: (context, index) {
                        return Container(
                          height: 30,
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(6),
                            color: Appcolors.white,
                            border: Border.all(
                              color: Appcolors.appPriSecColor.appPrimblue,
                            ),
                          ),
                          child: Center(
                            child: SizedBox(
                              child: label(
                                filtercontro.selectedType.value.isNotEmpty
                                    ? filtercontro
                                        .selectedType[index] // Convert list to a string
                                    : 'No Type Selected',
                                fontSize: 10,
                                maxLines: 2,
                                textColor: Appcolors.black,
                                fontWeight: FontWeight.w400,
                              ),
                            ),
                          ).paddingSymmetric(horizontal: 5),
                        );
                      },
                    )
                    : SizedBox.shrink(),
                filtercontro.selectedLocation.isNotEmpty &&
                        filtercontro.selectedLocation.first.isNotEmpty
                    ? sizeBoxWidth(10)
                    : SizedBox.shrink(),
                filtercontro.selectedLocation.isNotEmpty &&
                        filtercontro.selectedLocation.first.isNotEmpty
                    ? ListView.builder(
                      shrinkWrap: true,
                      scrollDirection: Axis.horizontal,
                      itemCount: filtercontro.selectedLocation.value.length,
                      itemBuilder: (context, index) {
                        return Padding(
                          padding: const EdgeInsets.symmetric(horizontal: 5),
                          child: Container(
                            height: 30,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(6),
                              color: Appcolors.white,
                              border: Border.all(
                                color: Appcolors.appPriSecColor.appPrimblue,
                              ),
                            ),
                            child: Center(
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  sizeBoxWidth(10),
                                  SizedBox(
                                    child: label(
                                      filtercontro.selectedLocation[index],
                                      fontSize: 10,
                                      maxLines: 2,
                                      textColor: Appcolors.black,
                                      fontWeight: FontWeight.w400,
                                    ),
                                  ),
                                  sizeBoxWidth(10),
                                ],
                              ),
                            ),
                          ),
                        );
                      },
                    )
                    : SizedBox.shrink(),
              ],
            ),
          ),
        ),
        GestureDetector(
          onTap: () {
            filtercontro.isnavfilter.value = false;
            nearcontro.nearbyApi(
              latitudee: SharedPrefs.getString(SharedPreferencesKey.LATTITUDE),
              longitudee: SharedPrefs.getString(SharedPreferencesKey.LONGITUDE),
              page: nearcontro.currentpage.toString(),
            );
          },
          child: label(
            'Clear All',
            fontSize: 10,
            textColor: Appcolors.black,
            fontWeight: FontWeight.w400,
          ),
        ),
      ],
    ).paddingSymmetric(horizontal: 20);
  }

  // -----------------------------------------------------------location list -----------------------------------------------------------

  Widget location_filter() {
    return filtercontro.isfilter.value
        ? Center(
          child: CupertinoActivityIndicator(
            color: Appcolors.appPriSecColor.appPrimblue,
          ),
        )
        : SizedBox(
          height: getProportionateScreenHeight(180),
          child: Container(
            height: Get.height,
            width: Get.width,
            decoration: BoxDecoration(
              color: Appcolors.white,
              borderRadius: BorderRadius.only(
                topLeft: ui.Radius.circular(15),
                topRight: ui.Radius.circular(15),
              ),
            ),
            child: ListView.builder(
              shrinkWrap: true,
              padding: EdgeInsets.zero,
              itemCount: filtercontro.filtermodel.value!.serviceFilter!.length,
              controller: filtercontro.scrollControllerlocation,
              scrollDirection: Axis.horizontal,
              itemBuilder: (context, index) {
                return Container(
                  height: Get.height,
                  width: Get.width,
                  decoration: BoxDecoration(color: Appcolors.white),
                  child: Column(
                    children: [
                      sizeBoxHeight(25),
                      GestureDetector(
                        onTap: () {
                          Get.to(
                            Details(
                              serviceid:
                                  filtercontro
                                      .filtermodel
                                      .value!
                                      .serviceFilter![index]
                                      .id
                                      .toString(),
                              isVendorService: false,
                            ),
                            transition: Transition.rightToLeft,
                          );
                        },
                        child: Container(
                          height: getProportionateScreenHeight(120),
                          width: Get.width * 0.90,
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(10),
                            color: Appcolors.white,
                            border: Border.all(color: Appcolors.grey300),
                          ),
                          child: Row(
                            children: [
                              Container(
                                height: getProportionateScreenHeight(120),
                                width: getProportionateScreenWidth(130),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.only(
                                    topLeft: Radius.circular(9),
                                    bottomLeft: Radius.circular(9),
                                  ),
                                  border: Border.all(color: Appcolors.white),
                                  image: DecorationImage(
                                    image: NetworkImage(
                                      filtercontro
                                          .filtermodel
                                          .value!
                                          .serviceFilter![index]
                                          .serviceImages![0]
                                          .toString(),
                                    ),
                                    fit: BoxFit.fill,
                                  ),
                                ),
                              ),
                              Column(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  sizeBoxHeight(3),
                                  Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      sizeBoxWidth(10),
                                      Container(
                                        height: 15,
                                        decoration: BoxDecoration(
                                          color:
                                              Appcolors
                                                  .appPriSecColor
                                                  .appPrimblue,
                                          borderRadius: BorderRadius.circular(
                                            3,
                                          ),
                                        ),
                                        child: Center(
                                          child: label(
                                            filtercontro
                                                .filtermodel
                                                .value!
                                                .serviceFilter![index]
                                                .categoryName
                                                .toString(),
                                            style: TextStyle(
                                              color: Appcolors.white,
                                              fontSize: 8,
                                            ),
                                          ).paddingOnly(left: 4, right: 4),
                                        ),
                                      ),
                                      // Container(
                                      //   height: 13,
                                      //   width: 45,
                                      //   decoration: BoxDecoration(
                                      //     color: Appcolors.appPriSecColor.appPrimblue,
                                      //     borderRadius:
                                      //         BorderRadius.circular(3),
                                      //   ),
                                      //   child: Center(
                                      //     child: Text(
                                      //       filtercontro
                                      //           .filtermodel
                                      //           .value!
                                      //           .serviceFilter![index]
                                      //           .categoryName
                                      //           .toString(),
                                      //       style: TextStyle(
                                      //           color: Appcolors.white,
                                      //           fontSize: 5),
                                      //     ),
                                      //   ),
                                      // ),
                                      sizeBoxWidth(130),
                                      GestureDetector(
                                        onTap: () {
                                          // Call the API to like/unlike the service
                                          if (SharedPrefs.getString(
                                            SharedPreferencesKey
                                                .LOGGED_IN_USERID,
                                          ).isEmpty) {
                                            snackBar(
                                              'Please login to like this service',
                                            );
                                            loginPopup(
                                              bottomsheetHeight:
                                                  Get.height * 0.95,
                                            );
                                          } else {
                                            likecontro.likeApi(
                                              filtercontro
                                                  .filtermodel
                                                  .value!
                                                  .serviceFilter![index]
                                                  .id
                                                  .toString(),
                                            );

                                            // Toggle the isLike value for the UI update (you may want to update this dynamically after the API call succeeds)
                                            setState(() {
                                              filtercontro
                                                  .filtermodel
                                                  .value!
                                                  .serviceFilter![index]
                                                  .isLike = filtercontro
                                                              .filtermodel
                                                              .value!
                                                              .serviceFilter![index]
                                                              .isLike ==
                                                          0
                                                      ? 1
                                                      : 0;
                                            });
                                          }
                                        },
                                        child: Container(
                                          height: 26,
                                          width: 26,
                                          decoration: BoxDecoration(
                                            shape: BoxShape.circle,
                                            color: Appcolors
                                                .appPriSecColor
                                                .appPrimblue
                                                .withValues(alpha: 0.10),
                                          ),
                                          child: Padding(
                                            padding: const EdgeInsets.all(6.0),
                                            child:
                                                filtercontro
                                                            .filtermodel
                                                            .value!
                                                            .serviceFilter![index]
                                                            .isLike ==
                                                        0
                                                    ? Image.asset(
                                                      AppAsstes.heart,
                                                    ) // Unlike
                                                    : Image.asset(
                                                      AppAsstes.fill_heart,
                                                    ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  label(
                                    filtercontro
                                        .filtermodel
                                        .value!
                                        .serviceFilter![index]
                                        .serviceName
                                        .toString(),
                                    fontSize: 11,
                                    textColor: Appcolors.brown,
                                    fontWeight: FontWeight.w600,
                                  ).paddingOnly(left: 10),
                                  SizedBox(height: 5),
                                  Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      sizeBoxWidth(10),
                                      Container(
                                        height: 24,
                                        width: 24,
                                        decoration: BoxDecoration(
                                          shape: BoxShape.circle,
                                          color: Appcolors
                                              .appPriSecColor
                                              .appPrimblue
                                              .withValues(alpha: 0.10),
                                        ),
                                        child: Padding(
                                          padding: const EdgeInsets.all(6.0),
                                          child: Image.asset(
                                            'assets/images/location1.png',
                                            color: Appcolors.black,
                                          ),
                                        ),
                                      ),
                                      sizeBoxWidth(10),
                                      SizedBox(
                                        width: 155,
                                        child: label(
                                          filtercontro
                                              .filtermodel
                                              .value!
                                              .serviceFilter![index]
                                              .address
                                              .toString(),
                                          maxLines: 1,
                                          fontSize: 10,
                                          textColor: Appcolors.black,
                                          fontWeight: FontWeight.w400,
                                        ),
                                      ),
                                    ],
                                  ),
                                  sizeBoxHeight(6),
                                  Row(
                                    children: [
                                      sizeBoxWidth(10),
                                      RatingBar.builder(
                                        itemPadding: const EdgeInsets.only(
                                          left: 1.5,
                                        ),
                                        initialRating:
                                            filtercontro
                                                        .filtermodel
                                                        .value!
                                                        .serviceFilter![index]
                                                        .averageReviewStar !=
                                                    ''
                                                ? double.parse(
                                                  filtercontro
                                                      .filtermodel
                                                      .value!
                                                      .serviceFilter![index]
                                                      .averageReviewStar!,
                                                )
                                                : 0.0,
                                        minRating: 0,
                                        direction: Axis.horizontal,
                                        allowHalfRating: true,
                                        itemCount: 5,
                                        itemSize: 10.5,
                                        ignoreGestures: true,
                                        unratedColor: Appcolors.grey400,
                                        itemBuilder:
                                            (context, _) => Image.asset(
                                              'assets/images/Star.png',
                                              height: 8,
                                            ),
                                        onRatingUpdate: (rating) {},
                                      ),
                                      SizedBox(width: 5),
                                      label(
                                        // ignore: unnecessary_string_escapes
                                        '(${filtercontro.filtermodel.value!.serviceFilter![index].totalReviewCount} \Review)',
                                        fontSize: 10,
                                        textColor: Appcolors.black,
                                        fontWeight: FontWeight.w400,
                                      ),
                                    ],
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ).paddingSymmetric(horizontal: 20),
                      ),
                    ],
                  ),
                );
              },
            ),
          ),
        );
  }

  // ignore: prefer_final_fields
  // ScrollController _scrollControllerlocation = ScrollController();

  List<Marker> markerList = <Marker>[];

  addMarker() async {
    if (nearcontro.nearbymodel.value?.nearbyService == null) {
      return; // Exit early if there's no data
    }
    final customIcon = await getResizedMarkerIcon(
      "assets/images/locationpick.png",
      48,
      48,
    );
    markerList.clear();
    for (int i = 0; i < nearcontro.nearbylist.length; i++) {
      final service = nearcontro.nearbylist[i];

      // Check for null lat or lon before parsing
      if (service.lat == null || service.lon == null) {
        continue; // Skip this entry if lat or lon is null
      }

      markerList.add(
        Marker(
          markerId: MarkerId('MarkerId$i'),
          position: LatLng(
            double.parse(service.lat!),
            double.parse(service.lon!),
          ),
          icon: customIcon,
          onTap: () {
            if (i >= 0 && i < nearcontro.nearbylist.length) {
              _scrollToIndex(i);
            }
          },
        ),
      );
    }

    if (mounted) {
      setState(() {});
    }
  }

  // List<Marker> filtermarkerList.value = <Marker>[];

  void _scrollToIndex(int index) {
    filtercontro.scrollControllerlocation.animateTo(
      index * 370.0, // Adjust 150.0 based on your item height
      duration: const Duration(milliseconds: 300),
      curve: Curves.easeInOut,
    );
  }

  Future<BitmapDescriptor> getCustomIcon() async {
    return await BitmapDescriptor.fromAssetImage(
      const ImageConfiguration(size: Size(01, 01)),
      "assets/images/locationpick.png",
    );
  }

  Future<BitmapDescriptor> getResizedMarkerIcon(
    String path,
    int width,
    int height,
  ) async {
    final byteData = await rootBundle.load(path);
    final codec = await ui.instantiateImageCodec(
      byteData.buffer.asUint8List(),
      targetWidth: width,
      targetHeight: height,
    );
    final frame = await codec.getNextFrame();
    final resized = await frame.image.toByteData(
      format: ui.ImageByteFormat.png,
    );
    return BitmapDescriptor.fromBytes(resized!.buffer.asUint8List());
  }

  Future<Uint8List> getBytesFromAsset(
    String path,
    int width,
    int height,
  ) async {
    final byteData = await rootBundle.load(path);
    final codec = await ui.instantiateImageCodec(
      byteData.buffer.asUint8List(),
      targetWidth: width,
      targetHeight: height,
    );
    final frame = await codec.getNextFrame();
    return (await frame.image.toByteData(
      format: ui.ImageByteFormat.png,
    ))!.buffer.asUint8List();
  }

  Widget location() {
    return FutureBuilder<BitmapDescriptor>(
      future: getResizedMarkerIcon('assets/images/locationpick.png', 48, 48),
      builder: (
        BuildContext context,
        AsyncSnapshot<BitmapDescriptor> snapshot,
      ) {
        if (snapshot.connectionState == ConnectionState.done &&
            snapshot.hasData) {
          final customIcon = snapshot.data!;

          // Optional: You can now assign this customIcon to your markers here
          // OR use it later in your addMarker() logic

          return Stack(
            clipBehavior: Clip.antiAlias,
            children: [
              ClipRRect(
                borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(30),
                  topRight: Radius.circular(30),
                ),
                child: GoogleMap(
                  onCameraMoveStarted: () {},
                  zoomGesturesEnabled: true,
                  initialCameraPosition: CameraPosition(
                    target: LatLng(
                      double.parse(
                        SharedPrefs.getString(SharedPreferencesKey.LATTITUDE),
                      ),
                      double.parse(
                        SharedPrefs.getString(SharedPreferencesKey.LONGITUDE),
                      ),
                    ),
                    zoom: 15,
                  ),
                  rotateGesturesEnabled: true,
                  markers: Set<Marker>.of(markerList),
                ),
              ),
              Positioned(
                bottom: 0,
                left: 0,
                right: 0,
                child: Nearby_location_listing(),
              ),
            ],
          );
        } else {
          return Center(
            child: CupertinoActivityIndicator(
              color: Appcolors.appPriSecColor.appPrimblue,
            ),
          );
        }
      },
    );
  }

  // Widget location() {
  //   return FutureBuilder<Uint8List>(
  //     future: getBytesFromAsset('assets/images/locationpick.png', 48, 48),
  //     builder: (BuildContext context, AsyncSnapshot<Uint8List> snapshot) {
  //       if (snapshot.connectionState == ConnectionState.done &&
  //           snapshot.hasData) {
  //         return Stack(
  //           clipBehavior: Clip.antiAlias,
  //           children: [
  //             ClipRRect(
  //               borderRadius: BorderRadius.only(
  //                 topLeft: Radius.circular(30),
  //                 topRight: Radius.circular(30),
  //               ),
  //               child: GoogleMap(
  //                 onCameraMoveStarted: () {},

  //                 zoomGesturesEnabled: true, // Enable Zoom in/out on the map
  //                 initialCameraPosition: CameraPosition(
  //                   target: LatLng(
  //                     double.parse(
  //                       SharedPrefs.getString(SharedPreferencesKey.LATTITUDE),
  //                     ),
  //                     double.parse(
  //                       SharedPrefs.getString(SharedPreferencesKey.LONGITUDE),
  //                     ),
  //                   ),
  //                   zoom: 15,
  //                 ),

  //                 rotateGesturesEnabled: true,

  //                 markers: Set<Marker>.of(markerList),
  //               ),
  //             ),
  //             Positioned(
  //               bottom: 0,
  //               right: 0,
  //               left: 0,
  //               child: Nearby_location_listing(),
  //             ),
  //           ],
  //         );
  //       } else {
  //         return Center(
  //           child: CupertinoActivityIndicator(
  //             color: Appcolors.appPriSecColor.appPrimblue,
  //           ),
  //         );
  //       }
  //     },
  //   );
  // }

  Widget location_() {
    return FutureBuilder<BitmapDescriptor>(
      future: getResizedMarkerIcon('assets/images/locationpick.png', 48, 48),
      builder: (
        BuildContext context,
        AsyncSnapshot<BitmapDescriptor> snapshot,
      ) {
        if (snapshot.connectionState == ConnectionState.done &&
            snapshot.hasData) {
          return Stack(
            clipBehavior: Clip.antiAlias,
            children: [
              Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                ),
                height: Get.height,
                child: Stack(
                  clipBehavior: Clip.antiAlias,
                  children: [
                    Column(
                      children: [
                        // filter_clear(),
                        // ListView.builder(
                        //     shrinkWrap: true,
                        //     itemCount: filtercontro.filtermarkerList.length,
                        //     itemBuilder: (context, index) {
                        //       return Text(filtercontro
                        //           .filtermarkerList[index].position
                        //           .toString());
                        //     }),
                        Expanded(
                          child: ClipRRect(
                            borderRadius: BorderRadius.only(
                              topLeft: Radius.circular(30),
                              topRight: Radius.circular(30),
                            ),
                            child: GoogleMap(
                              onCameraMoveStarted: () {
                                // if (mounted) {
                                //   setState(() {});
                                // }
                              },

                              zoomGesturesEnabled:
                                  true, // Enable Zoom in/out on the map
                              initialCameraPosition: CameraPosition(
                                target: LatLng(
                                  double.parse(
                                    SharedPrefs.getString(
                                      SharedPreferencesKey.LATTITUDE,
                                    ),
                                  ),
                                  double.parse(
                                    SharedPrefs.getString(
                                      SharedPreferencesKey.LONGITUDE,
                                    ),
                                  ),
                                ),
                                zoom: 15,
                              ),

                              rotateGesturesEnabled: true,

                              markers: Set<Marker>.of(
                                filtercontro.filtermarkerList.value,
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                    Positioned(
                      bottom: 0,
                      right: 0,
                      left: 0,
                      child: Obx(() {
                        return filtercontro.isfilter.value
                            ? SizedBox.shrink()
                            : filtercontro
                                .filtermodel
                                .value!
                                .serviceFilter!
                                .isNotEmpty
                            ? location_filter()
                            : Container(
                              height: getProportionateScreenHeight(150),
                              width: Get.width,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.only(
                                  topLeft: ui.Radius.circular(15),
                                  topRight: ui.Radius.circular(15),
                                ),
                                color: Appcolors.white,
                                boxShadow: [
                                  BoxShadow(
                                    color: Appcolors.grey200,
                                    blurRadius: 14.0,
                                    spreadRadius: 0.0,
                                    offset: const Offset(
                                      2.0,
                                      4.0,
                                    ), // shadow direction: bottom right
                                  ),
                                ],
                              ),
                              child: Column(
                                mainAxisAlignment: MainAxisAlignment.center,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  label(
                                    languageController.textTranslate(
                                      'No Store available in your Location',
                                    ),
                                    fontSize: 13,
                                    textColor: Appcolors.black,
                                    fontWeight: FontWeight.w400,
                                  ),
                                ],
                              ),
                            );
                      }),
                    ),
                  ],
                ),
              ),
            ],
          );
        } else {
          return Center(
            child: CupertinoActivityIndicator(
              color: Appcolors.appPriSecColor.appPrimblue,
            ),
          );
        }
      },
    );
  }

  Widget buildBottomLoaderOrMessage() {
    if (!nearcontro.hasMoreData.value) {
      return Center(
        child: Text(
          "No more services found",
          style: TextStyle(fontSize: 16, color: Colors.grey),
        ),
      );
    } else {
      return Center(
        child: SizedBox(height: 30, width: 30, child: commonLoading()),
      );
    }
  }

  Widget listing() {
    if (nearcontro.isnear.value && nearcontro.currentpage.value == 1) {
      // Show shimmer when page 1 loads
      return CircularProgressIndicator();
    } else if (nearcontro.nearbylist.isEmpty) {
      // No data found
      return explore_empty();
    }
    return GridView.builder(
      itemCount:
          nearcontro.nearbylist.length +
          (isLoadingMore || !nearcontro.hasMoreData.value ? 1 : 0),
      padding: EdgeInsets.zero,
      scrollDirection: Axis.vertical,
      physics: AlwaysScrollableScrollPhysics(),
      controller: scrollController,
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
        crossAxisCount: 2, // 2 items in a row
        childAspectRatio: 0.58, // Adjust for image and text ratio
        crossAxisSpacing: 10,
        mainAxisSpacing: 10,
      ),
      itemBuilder: (context, index) {
        if (index < nearcontro.nearbylist.length) {
          return CommanScreen(
            lat: nearcontro.nearbylist[index].lat,
            lon: nearcontro.nearbylist[index].lon,
            storeImages:
                nearcontro.nearbylist[index].serviceImages![0].toString(),
            sname:
                nearcontro.nearbylist[index].serviceName!.capitalizeFirst
                    .toString(),
            cname:
                nearcontro.nearbylist[index].categoryName!.capitalizeFirst
                    .toString(),
            vname: nearcontro.nearbylist[index].vendorFirstName.toString(),
            vendorImages: nearcontro.nearbylist[index].vendorImage.toString(),
            isfeatured: nearcontro.nearbylist[index].isFeatured!,
            ratingCount:
                nearcontro.nearbylist[index].totalAvgReview!.isNotEmpty
                    ? double.parse(nearcontro.nearbylist[index].totalAvgReview!)
                    : 0,
            avrageReview:
                nearcontro.nearbylist[index].totalReviewCount!.toString(),
            isLike:
                SharedPrefs.getString(
                      SharedPreferencesKey.LOGGED_IN_USERID,
                    ).isEmpty
                    ? 0
                    : nearcontro.nearbylist[index].isLike!,
            onTaplike: () {
              if (SharedPrefs.getString(
                SharedPreferencesKey.LOGGED_IN_USERID,
              ).isEmpty) {
                snackBar('Please login to like this service');
                loginPopup(bottomsheetHeight: Get.height * 0.95);
              } else {
                likecontro.likeApi(nearcontro.nearbylist[index].id.toString());

                // Toggle the isLike value for the UI update (you may want to update this dynamically after the API call succeeds)
                setState(() {
                  nearcontro.nearbylist[index].isLike =
                      nearcontro.nearbylist[index].isLike == 0 ? 1 : 0;
                });
              }
            },
            onTapstore: () {
              Get.to(
                Details(
                  serviceid: nearcontro.nearbylist[index].id.toString(),
                  isVendorService: false,
                ),
                transition: Transition.rightToLeft,
              );
            },
            location: nearcontro.nearbylist[index].address.toString(),
            price: 'From ${nearcontro.nearbylist[index].priceRange}',
          );
        } else {
          return Shimmer.fromColors(
            baseColor: Appcolors.grey300,
            highlightColor: Appcolors.grey100,
            child: Card(
              color: Appcolors.white,
              shape: const RoundedRectangleBorder(
                // side: BorderSide(color: Appcolors.grey100),
                borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(15),
                  topRight: Radius.circular(15),
                  bottomLeft: Radius.circular(9),
                  bottomRight: Radius.circular(9),
                ),
              ),
              child: Stack(
                children: [
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.stretch,
                    children: [
                      const ClipRRect(
                        borderRadius: BorderRadius.only(
                          topLeft: Radius.circular(10),
                          topRight: Radius.circular(10),
                          bottomLeft: Radius.circular(22),
                          bottomRight: Radius.circular(22),
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          );
        }
      },
    ).paddingSymmetric(horizontal: 15, vertical: 5);
  }

  Widget Nearby_location_listing() {
    return nearcontro.nearbylist.isNotEmpty
        ? SizedBox(
          height: getProportionateScreenHeight(180),
          child: Container(
            height: Get.height,
            width: Get.width,
            decoration: BoxDecoration(
              color:
                  themeContro.isLightMode.value
                      ? Appcolors.white
                      : Appcolors.darkMainBlack,
              borderRadius: BorderRadius.only(
                topLeft: ui.Radius.circular(15),
                topRight: ui.Radius.circular(15),
              ),
            ),
            child: ListView.builder(
              controller: filtercontro.scrollControllerlocation,
              shrinkWrap: true,
              itemCount: nearcontro.nearbylist.length,
              scrollDirection: Axis.horizontal,
              itemBuilder: (context, index) {
                return Column(
                  children: [
                    sizeBoxHeight(25),
                    GestureDetector(
                      onTap: () {
                        Get.to(
                          Details(
                            serviceid:
                                nearcontro.nearbylist[index].id.toString(),
                            isVendorService: false,
                          ),
                          transition: Transition.rightToLeft,
                        );
                      },
                      child: Container(
                        height: getProportionateScreenHeight(120),
                        width: Get.width * 0.90,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(10),
                          color:
                              themeContro.isLightMode.value
                                  ? Appcolors.white
                                  : Appcolors.darkGray,
                          border: Border.all(
                            color:
                                themeContro.isLightMode.value
                                    ? Appcolors.grey300
                                    : Appcolors.black.withOpacity(0.8),
                          ),
                        ),
                        child: Row(
                          children: [
                            Container(
                              height: getProportionateScreenHeight(120),
                              width: getProportionateScreenWidth(130),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.only(
                                  topLeft: Radius.circular(9),
                                  bottomLeft: Radius.circular(9),
                                ),
                                border: Border.all(
                                  color:
                                      themeContro.isLightMode.value
                                          ? Appcolors.grey300
                                          : Appcolors.black.withOpacity(0.8),
                                ),
                                image: DecorationImage(
                                  onError: (exception, stackTrace) {
                                    Icon(Icons.error);
                                  },
                                  image: NetworkImage(
                                    nearcontro
                                        .nearbylist[index]
                                        .serviceImages![0]
                                        .toString(),
                                  ),
                                  fit: BoxFit.fill,
                                ),
                              ),
                            ),
                            Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                sizeBoxHeight(3),
                                Row(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    sizeBoxWidth(10),
                                    Container(
                                      height: 15,
                                      decoration: BoxDecoration(
                                        color:
                                            Appcolors
                                                .appPriSecColor
                                                .appPrimblue,
                                        borderRadius: BorderRadius.circular(3),
                                      ),
                                      child: Center(
                                        child: SizedBox(
                                          width: 55,
                                          child: label(
                                            nearcontro
                                                .nearbylist[index]
                                                .categoryName
                                                .toString(),
                                            maxLines: 1,
                                            style: TextStyle(
                                              color: Appcolors.white,
                                              overflow: TextOverflow.ellipsis,
                                              fontSize: 8,
                                            ),
                                          ).paddingOnly(left: 4, right: 4),
                                        ),
                                      ),
                                    ),
                                    // Container(
                                    //   height: 13,
                                    //   width: 45,
                                    //   decoration: BoxDecoration(
                                    //     color: Appcolors.appPriSecColor.appPrimblue,
                                    //     borderRadius:
                                    //         BorderRadius.circular(3),
                                    //   ),
                                    //   child: Center(
                                    //     child: Text(
                                    //       nearcontro.nearbylist[index]
                                    //           .categoryName
                                    //           .toString(),
                                    //       style: TextStyle(
                                    //           color: Appcolors.white,
                                    //           fontSize: 5),
                                    //     ),
                                    //   ),
                                    // ),
                                    sizeBoxWidth(130),
                                    GestureDetector(
                                      onTap: () {
                                        if (SharedPrefs.getString(
                                          SharedPreferencesKey.LOGGED_IN_USERID,
                                        ).isEmpty) {
                                          snackBar(
                                            'Please login to like this service',
                                          );
                                          loginPopup(
                                            bottomsheetHeight:
                                                Get.height * 0.95,
                                          );
                                        } else {
                                          likecontro.likeApi(
                                            nearcontro.nearbylist[index].id
                                                .toString(),
                                          );

                                          setState(() {
                                            nearcontro
                                                .nearbylist[index]
                                                .isLike = nearcontro
                                                            .nearbylist[index]
                                                            .isLike ==
                                                        0
                                                    ? 1
                                                    : 0;
                                          });
                                        }
                                      },
                                      child: Container(
                                        height: 26,
                                        width: 26,
                                        decoration: BoxDecoration(
                                          shape: BoxShape.circle,
                                          color: Appcolors
                                              .appPriSecColor
                                              .appPrimblue
                                              .withValues(alpha: 0.10),
                                        ),
                                        child: Padding(
                                          padding: const EdgeInsets.all(6.0),
                                          child:
                                              nearcontro
                                                          .nearbylist[index]
                                                          .isLike ==
                                                      0
                                                  ? Image.asset(
                                                    AppAsstes.heart,
                                                    color:
                                                        themeContro
                                                                .isLightMode
                                                                .value
                                                            ? Appcolors.black
                                                            : Appcolors.grey1,
                                                  )
                                                  : Image.asset(
                                                    AppAsstes.fill_heart,
                                                  ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  width: Get.width * 0.5,
                                  child: label(
                                    nearcontro.nearbylist[index].serviceName
                                        .toString(),
                                    fontSize: 11,
                                    maxLines: 1,
                                    textColor:
                                        themeContro.isLightMode.value
                                            ? Appcolors.brown
                                            : Appcolors.white,
                                    fontWeight: FontWeight.w600,
                                  ).paddingOnly(left: 10),
                                ),
                                SizedBox(height: 5),
                                Row(
                                  children: [
                                    sizeBoxWidth(10),
                                    Container(
                                      height: 24,
                                      width: 24,
                                      decoration: BoxDecoration(
                                        shape: BoxShape.circle,
                                        color: Appcolors
                                            .appPriSecColor
                                            .appPrimblue
                                            .withValues(alpha: 0.10),
                                      ),
                                      child: Padding(
                                        padding: const EdgeInsets.all(6.0),
                                        child: Image.asset(
                                          'assets/images/location1.png',
                                          color:
                                              themeContro.isLightMode.value
                                                  ? Appcolors.black
                                                  : Appcolors
                                                      .appPriSecColor
                                                      .appPrimblue,
                                        ),
                                      ),
                                    ),
                                    sizeBoxWidth(10),
                                    SizedBox(
                                      width: 155,
                                      child: label(
                                        nearcontro.nearbylist[index].address
                                            .toString(),
                                        maxLines: 1,
                                        fontSize: 10,
                                        textColor:
                                            themeContro.isLightMode.value
                                                ? Appcolors.black
                                                : Appcolors.brown,
                                        fontWeight: FontWeight.w400,
                                      ),
                                    ),
                                  ],
                                ),
                                sizeBoxHeight(6),
                                Row(
                                  children: [
                                    sizeBoxWidth(10),
                                    RatingBar.builder(
                                      itemPadding: const EdgeInsets.only(
                                        left: 1.5,
                                      ),
                                      initialRating:
                                          nearcontro
                                                      .nearbylist[index]
                                                      .totalAvgReview !=
                                                  ''
                                              ? double.parse(
                                                nearcontro
                                                    .nearbylist[index]
                                                    .totalAvgReview!,
                                              )
                                              : 0.0,
                                      minRating: 0,
                                      direction: Axis.horizontal,
                                      allowHalfRating: true,
                                      itemCount: 5,
                                      itemSize: 10.5,
                                      ignoreGestures: true,
                                      unratedColor: Appcolors.grey400,
                                      itemBuilder:
                                          (context, _) => Image.asset(
                                            'assets/images/Star.png',
                                            height: 8,
                                          ),
                                      onRatingUpdate: (rating) {},
                                    ),
                                    SizedBox(width: 5),
                                    label(
                                      '(${nearcontro.nearbylist[index].totalReviewCount} Review)',
                                      fontSize: 10,
                                      textColor:
                                          themeContro.isLightMode.value
                                              ? Appcolors.black
                                              : Appcolors.white,
                                      fontWeight: FontWeight.w400,
                                    ),
                                  ],
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ).paddingSymmetric(horizontal: 20);
              },
            ),
          ),
        )
        : Container(
          height: getProportionateScreenHeight(180),
          width: Get.width,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              topLeft: ui.Radius.circular(15),
              topRight: ui.Radius.circular(15),
            ),
            color: Appcolors.white,
          ),
          child: Column(
            children: [
              sizeBoxHeight(35),
              Image.asset(
                'assets/images/Illustration.png',
                height: 65,
                width: 65,
              ),
              sizeBoxHeight(1),
              label(
                languageController.textTranslate(
                  'No Store available in \n your Location',
                ),
                fontSize: 8,
                textColor: Appcolors.black,
                fontWeight: FontWeight.w400,
                textAlign: TextAlign.center,
              ),
            ],
          ),
        );
  }

  Widget explore_empty() {
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          SizedBox(
            height: 150,
            child: Image.asset(
              'assets/images/Animation - 1736233762512.gif', // Path to your Lottie JSON file
              width: 200,
              height: 180,
            ),
          ),
          Text(
            languageController.textTranslate("Explore List Not Available"),
            textAlign: TextAlign.center,
            style: AppTypography.h3(context),
          ),
        ],
      ),
    );
  }
}
