<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('campaign', function (Blueprint $table) {
            $table->integer('id', false, true)->length(11)->autoIncrement(); // int(11) unsigned
            $table->integer('vendor_id', false, true)->length(11)->nullable(); // int(11) unsigned nullable
            $table->integer('service_id', false, true)->length(11)->nullable(); // int(11) unsigned nullable
            $table->text('campaign_name')->nullable(); // Campaign name (nullable)
            $table->text('address')->nullable(); // Address (nullable)
            $table->text('lat')->nullable(); // Latitude (nullable)
            $table->text('lon')->nullable(); // Longitude (nullable)
            $table->text('area_distance')->nullable(); // Area distance (nullable)
            $table->timestamps(); // created_at and updated_at
        });
        
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaign');
    }
};
