<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chats', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned
            $table->string('from_user', 255)->nullable();
            $table->string('to_user', 255)->nullable();
            $table->text('message')->nullable();
            $table->text('url')->nullable();
            $table->string('type', 255)->nullable();
            $table->string('read_message', 255)->nullable()->default('0');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chats');
    }
};
