<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_support', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned primary key
            $table->text('name')->nullable(); // name of the customer
            $table->text('email')->nullable(); // email address
            $table->text('phone')->nullable(); // contact number
            $table->text('message')->nullable(); // support message
            $table->timestamp('created_at')->nullable(); // created timestamp
            $table->timestamp('updated_at')->nullable(); // updated timestamp
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_support');
    }
};
