<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_cards', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned AUTO_INCREMENT
            $table->integer('category_id', false, true)->nullable(); // int(11) unsigned nullable
            $table->text('title')->nullable();
            $table->text('image')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('home_cards')->insert([
            'id' => 1,
            'category_id' => 1,
            'title' => '"From Dull to Dazzling — Skincare That Works!"',
            'image' => '174229462067d94e5c568a8.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_cards')->insert([
            'id' => 2,
            'category_id' => 2,
            'title' => 'Your Favorite Spot for Food and Friends.',
            'image' => '174229485367d94f45de633.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_cards')->insert([
            'id' => 3,
            'category_id' => 3,
            'title' => 'Building Communities, One Home at a Time.',
            'image' => '174229665667d95650efa45.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_cards')->insert([
            'id' => 4,
            'category_id' => 4,
            'title' => 'Beyond Books: Real Learning Happens Here.',
            'image' => '174229788667d95b1e471fe.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_cards');
    }
};
