<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_subscriptions', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary key: int(11) unsigned
            $table->text('title')->nullable();                  // text nullable
            $table->text('subtext')->nullable();                // text nullable
            $table->timestamp('created_at')->nullable();        // timestamp nullable
            $table->timestamp('updated_at')->nullable();        // timestamp nullable
        });

        // Insert default admin record
        DB::table('home_subscriptions')->insert([
            'id' => 1,
            'title' => 'Our Pricing Plan',
            'subtext' => 'Affordable price Packages',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_subscriptions');
    }
};
