<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_testimonals', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary key: int(11) unsigned
            $table->text('title')->nullable();                  // text nullable
            $table->text('subtext')->nullable();                // text nullable
            $table->text('body')->nullable();                   // text nullable
            $table->text('image')->nullable();                  // text nullable
            $table->timestamp('created_at')->nullable();        // timestamp nullable
            $table->timestamp('updated_at')->nullable();        // timestamp nullable
        });

        // Insert default admin record
        DB::table('home_testimonals')->insert([
            'id' => 1,
            'title' => 'Top Trending',
            'subtext' => 'Client Reviews',
            'body' => 'Clint Eastwood delivers another masterclass in storytelling, blending grit, heart, and timeless themes with unparalleled precisions.',
            'image' => '174230348667d970fe9e58b.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_testimonals');
    }
};
