<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('index_slider', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary key: int(11) unsigned
            $table->text('title')->nullable();                   // text nullable
            $table->text('body')->nullable();                    // text nullable
            $table->text('image')->nullable();                   // text nullable
            $table->text('link')->nullable();                    // text nullable
            $table->timestamp('created_at')->nullable();         // timestamp nullable
            $table->timestamp('updated_at')->nullable();         // timestamp nullable
        });

        // Insert default admin record
        DB::table('index_slider')->insert([
            'id' => 1,
            'title' => 'Reliable Solutions for all your home repair and maintenance needs.',
            'body' => "We bring your vision to life with skilled hands and expert craftsmanship. Whether you're looking for a complete home makeover or small improvements, our team of experienced professionals is here to help. From renovations to repairs, painting to plumbing, flooring to electrical work—we handle it all with precision and care.",
            'image' => '174229430267d94d1ec771a.jpg',
            'link' => 'https://nlyticalapp.com/store',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('index_slider');
    }
};
