<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mobile_url', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->text('android_url')->nullable();
            $table->text('android_provider_url')->nullable();
            $table->text('ios_url')->nullable();
            $table->text('ios_provider_url')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('mobile_url')->insert([
            'id' => 1,
            'android_url' => 'https://twitter.com/iqonicdesign',
            'android_provider_url' => 'https://twitter.com/iqonicdesign',
            'ios_url' => 'https://twitter.com/iqonicdesign',
            'ios_provider_url' => 'https://twitter.com/iqonicdesign',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mobile_url');
    }
};
