<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_likes', function (Blueprint $table) {
            $table->id(); // AUTO_INCREMENT primary key
            $table->integer('user_id')->nullable(); // User who liked
            $table->integer('service_id')->nullable(); // Service being liked
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_likes');
    }
};
