<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_plan', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->text('plan_name')->nullable();
            $table->text('description')->nullable();
            $table->string('price')->nullable(); // varchar(255)
            $table->string('validity_day')->nullable(); // varchar(255)
            $table->text('image')->nullable();
            $table->text('subtext')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('subscription_plan')->insert([
            'id' => 1,
            'plan_name' => 'Startup Plan',
            'description' => "<p>24/7 Consultancy Service</p><p>Market Research and Analysis</p><p>Financial Planning and Budgeting</p><p>Branding and Marketing Strategies</p>",
            'price' => '25',
            'validity_day' => null,
            'image' => null,
            'subtext' => 'Ideal for new businesses, entrepreneurs, and small teams, the Startup Plan offers essential tools to kickstart growth.',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('subscription_plan')->insert([
            'id' => 2,
            'plan_name' => 'Enterprise Plan',
            'description' => "<p>24/7 Consultancy Service</p><p>Market Research and Analysis</p><p>Financial Planning and Budgeting</p><p>Branding and Marketing Strategies</p>",
            'price' => '30',
            'validity_day' => null,
            'image' => null,
            'subtext' => 'Tailored for large-scale operations and high-demand businesses.',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);



        // Insert default admin record
        DB::table('subscription_plan')->insert([
            'id' => 3,
            'plan_name' => 'Business Plan',
            'description' => "<p>24/7 Consultancy Service</p><p>Market Research and Analysis</p><p>Financial Planning and Budgeting</p><p>Branding and Marketing Strategies</p>",
            'price' => '45',
            'validity_day' => null,
            'image' => null,
            'subtext' => 'A comprehensive solution designed for growing businesses and established enterprises.',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_plan');
    }
};
