import React, { lazy } from "react";
import { BrowserRouter } from "react-router-dom";
import { Toaster } from "react-hot-toast";
import AppRoutes from "./routes/AppRoutes";
import MainLayout from "./routes/MainLayout";
import { useAppSelector } from "./Hooks/Hooks";
import { ThemeContextProvider } from "./Context/ThemeContext";
import { AuthProvider } from "./utils/AuthContext";
import LazyModalWrapper from "./Componets/LazyModalWrapper";


// 💤 Lazy load all modals
const Admin_Block_Modal = lazy(() => import("./Componets/AllModals/Admin_Block_Modal"));
const Gift_Image_Modal = lazy(() => import("./Componets/AllModals/Gift_Image_Modal"));
const Add_Gift_Modal = lazy(() => import("./Componets/AllModals/Add_Gift_Modal"));
const Update_Gift_Modal = lazy(() => import("./Componets/AllModals/Update_Gift_Modal/Update_Gift_Modal"));
const Log_Out_Modal = lazy(() => import("./Componets/AllModals/Log_Out_Modal"));
const UpdateLanguage_Modal = lazy(() => import("./Componets/AllModals/UpdateLanguage_Modal/UpdateLanguage_Modal"));
const AddLanguage_Modal = lazy(() => import("./Componets/AllModals/AddLanguage_Modal/AddLanguage_Modal"));
const AddGiftCategory = lazy(() => import("./Componets/AllModals/AddGiftCategory/AddGiftCategory"));
const MusicDelete_Modal = lazy(() => import("./Componets/AllModals/MusicDelete_Modal/MusicDelete_Modal"));
const MusicAdd_Modal = lazy(() => import("./Componets/AllModals/MusicAdd_Modal/MusicAdd_Modal"));
const MusicUpdate_Modal = lazy(() => import("./Componets/AllModals/MusicUpdate_Modal/MusicUpdate_Modal"));
const UploadMusicModalWithS3 = lazy(() => import("./Componets/AllModals/UploadMusicModalWithS3/UploadMusicModalWithS3"));
const AddCategoryModal = lazy(() => import("./Componets/AllModals/AddCategoryModal/AddCategoryModal"));
const AddSubCategoryModal = lazy(() => import("./Componets/AllModals/AddSubCategoryModal/AddSubCategoryModal"));
const CategoryDeleteModal = lazy(() => import("./Componets/AllModals/CategoryDeleteModal"));
const CategoryUpdateModal = lazy(() => import("./Componets/AllModals/CategoryUpdateModal/CategoryUpdateModal"));
const UpdateSubCategoryModal = lazy(() => import("./Componets/AllModals/UpdateSubCategoryModal/UpdateSubCategoryModal"));
const SubCategoryDeleteModal = lazy(() => import("./Componets/AllModals/SubCategoryDeleteModal"));
const CategoryListValuesShowModal = lazy(() => import("./Componets/AllModals/CategoryListValuesShowModal/CategoryListValuesShowModal"));
const SubcriptionPlanlListAddModal = lazy(() => import("./Componets/AllModals/SubcriptionPlanlListAddModal/SubcriptionPlanlListAddModal"));
const SubscriptionPlanDeleteModal = lazy(() => import("./Componets/AllModals/SubscriptionPlanDeleteModal"));
const SubscriptionPlanUpdateModal = lazy(() => import("./Componets/AllModals/SubscriptionPlanUpdateModal"));
const ServiceDeleteModal = lazy(() => import("./Componets/AllModals/ServiceDeleteModal"));
const StooreDeleteModal = lazy(() => import("./Componets/AllModals/StooreDeleteModal"));
const AddFAQModal = lazy(() => import("./Componets/AllModals/AddFAQModal"));
const UpdateFAQModal = lazy(() => import("./Componets/AllModals/UpdateFAQModal"));
const DeleteUpdateFAQModal = lazy(() => import("./Componets/AllModals/DeleteUpdateFAQModal"));
const AddReportTextModal = lazy(() => import("./Componets/AllModals/AddReportTextModal"));
const DeleteReporModal = lazy(() => import("./Componets/AllModals/DeleteReporModal"));
const AddClientReviewModal = lazy(() => import("./Componets/AllModals/AddClientReviewModal/AddClientReviewModal"));
const DeleteClientModal = lazy(() => import("./Componets/AllModals/DeleteClientModal"));
const AddCurrencyModal = lazy(() => import("./Componets/AllModals/AddCurrencyModal"));
const DeleteCurrencyModal = lazy(() => import("./Componets/AllModals/DeleteCurrencyModal"));
const DeleteCustomerSuportModal = lazy(() => import("./Componets/AllModals/DeleteCustomerSuportModal"));
const AddSliderModal = lazy(() => import("./Componets/AllModals/AddSliderModal/AddSliderModal"));
const DeleteSliderModal = lazy(() => import("./Componets/AllModals/DeleteSliderModal"));
const DeleteReviewModal = lazy(() => import("./Componets/AllModals/DeleteReviewModal"));
const UpdateReviewModal = lazy(() => import("./Componets/AllModals/UpdateReviewModal"));
const DeleteToken = lazy(() => import("./Componets/AllModals/DeleteToken"));
const UpdateSliderModal = lazy(() => import("./Componets/AllModals/UpdateSliderModal/UpdateSliderModal"))
const DeleteReviewViewStore = lazy(() => import("./Componets/AllModals/DeleteReviewViewStore"))


const App: React.FC = () => {
  const modalState = useAppSelector((state) => state.modals);

  return (
    <>
      <div className="w-full h-screen">
        <AuthProvider>
          <BrowserRouter>
            <ThemeContextProvider>
              <Toaster position="top-center" reverseOrder={false} />
              <MainLayout>
                <AppRoutes />
              </MainLayout>
            </ThemeContextProvider>
          </BrowserRouter>
        </AuthProvider>
      </div>

      {/* 🎯 Render Modals only if their flag is true */}
      <LazyModalWrapper condition={modalState.Admin_Block_Modal} Component={Admin_Block_Modal} />
      <LazyModalWrapper condition={modalState.Gift_Image_Modal} Component={Gift_Image_Modal} />
      <LazyModalWrapper condition={modalState.Add_Gift_Modal} Component={Add_Gift_Modal} />
      <LazyModalWrapper condition={modalState.Update_Gift_Modal} Component={Update_Gift_Modal} />
      <LazyModalWrapper condition={modalState.Log_Out_Modal} Component={Log_Out_Modal} />
      <LazyModalWrapper condition={modalState.UpdateLanguage_Modal} Component={UpdateLanguage_Modal} />
      <LazyModalWrapper condition={modalState.AddLanguage_Modal} Component={AddLanguage_Modal} />
      <LazyModalWrapper condition={modalState.AddGiftCategory} Component={AddGiftCategory} />
      <LazyModalWrapper condition={modalState.MusicDelete_Modal} Component={MusicDelete_Modal} />
      <LazyModalWrapper condition={modalState.MusicAdd_Modal} Component={MusicAdd_Modal} />
      <LazyModalWrapper condition={modalState.MusicUpdate_Modal} Component={MusicUpdate_Modal} />
      <LazyModalWrapper condition={modalState.UploadMusicModalWithS3} Component={UploadMusicModalWithS3} />
      <LazyModalWrapper condition={modalState.AddCategoryModal} Component={AddCategoryModal} />
      <LazyModalWrapper condition={modalState.AddSubCategoryModal} Component={AddSubCategoryModal} />
      <LazyModalWrapper condition={modalState.CategoryDeleteModal} Component={CategoryDeleteModal} />
      <LazyModalWrapper condition={modalState.CategoryUpdateModal} Component={CategoryUpdateModal} />
      <LazyModalWrapper condition={modalState.UpdateSubCategoryModal} Component={UpdateSubCategoryModal} />
      <LazyModalWrapper condition={modalState.SubCategoryDeleteModal} Component={SubCategoryDeleteModal} />
      <LazyModalWrapper condition={modalState.CategoryListValuesShowModal} Component={CategoryListValuesShowModal} />
      <LazyModalWrapper condition={modalState.SubcriptionPlanlListAddModal} Component={SubcriptionPlanlListAddModal} />
      <LazyModalWrapper condition={modalState.SubscriptionPlanDeleteModal} Component={SubscriptionPlanDeleteModal} />
      <LazyModalWrapper condition={modalState.SubscriptionPlanUpdateModal} Component={SubscriptionPlanUpdateModal} />
      <LazyModalWrapper condition={modalState.ServiceDeleteModal} Component={ServiceDeleteModal} />
      <LazyModalWrapper condition={modalState.StooreDeleteModal} Component={StooreDeleteModal} />
      <LazyModalWrapper condition={modalState.AddFAQModal} Component={AddFAQModal} />
      <LazyModalWrapper condition={modalState.UpdateFAQModal} Component={UpdateFAQModal} />
      <LazyModalWrapper condition={modalState.DeleteUpdateFAQModal} Component={DeleteUpdateFAQModal} />
      <LazyModalWrapper condition={modalState.AddReportTextModal} Component={AddReportTextModal} />
      <LazyModalWrapper condition={modalState.DeleteReporModal} Component={DeleteReporModal} />
      <LazyModalWrapper condition={modalState.AddClientReviewModal} Component={AddClientReviewModal} />
      <LazyModalWrapper condition={modalState.DeleteClientModal} Component={DeleteClientModal} />
      <LazyModalWrapper condition={modalState.AddCurrencyModal} Component={AddCurrencyModal} />
      <LazyModalWrapper condition={modalState.DeleteCurrencyModal} Component={DeleteCurrencyModal} />
      <LazyModalWrapper condition={modalState.DeleteCustomerSuportModal} Component={DeleteCustomerSuportModal} />
      <LazyModalWrapper condition={modalState.AddSliderModal} Component={AddSliderModal} />
      <LazyModalWrapper condition={modalState.DeleteSliderModal} Component={DeleteSliderModal} />
      <LazyModalWrapper condition={modalState.DeleteReviewModal} Component={DeleteReviewModal} />
      <LazyModalWrapper condition={modalState.UpdateReviewModal} Component={UpdateReviewModal} />
      <LazyModalWrapper condition={modalState.DeleteToken} Component={DeleteToken} />
      <LazyModalWrapper condition={modalState.UpdateSliderModal} Component={UpdateSliderModal} />
       <LazyModalWrapper condition={modalState.DeleteReviewViewStore} Component={DeleteReviewViewStore} />
    </>
  );
};

export default App;
