import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";

export const UsegetAdminDetail = () => {
  const baseURL = import.meta.env.VITE_API_URL;

  return useQuery({
    queryKey: ["update-adminprofile"],
    queryFn: async () => {
      const token = Cookies.get("token");

      if (!token) {
        throw new Error("No token found");
      }

      const response = await axios.post(
        `${baseURL}/update-adminprofile`,
        {
          user_id: 1, // Pass user_id in the request body
        },
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        }
      );

      return response.data;
    },
    staleTime: Infinity,
  });
};
