import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { CategoryValues } from "../../Types/Types";

export const UseGetCategory = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<CategoryValues, Error>({
        queryKey: ["category-list"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<CategoryValues>(
                `${baseURL}/category-list`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
