import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { SettingGeneralSetting } from "../../Types/Types";

export const UseGetGeneralSetting = () => {
    const baseURL = import.meta.env.VITE_API_URL;
    
    return useQuery<SettingGeneralSetting, Error>({
        queryKey: ["general-settings"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<SettingGeneralSetting>(
                `${baseURL}/general-settings`,

                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
