import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { GetVendorDetailRes } from "../../Types/Types";

export const UseGetVendordetail = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    const user_id = sessionStorage.getItem("user_id")

    return useQuery<GetVendorDetailRes, Error>({
        queryKey: ["get-vendorview", user_id], // Include user_id in the query key
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<GetVendorDetailRes>(
                `${baseURL}/get-vendorview`,
                { user_id }, // Pass user_id in the request body
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
        enabled: !!user_id, // Only run the query if user_id exists
    });
};
