import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { PhoneSetup } from "../../Types/Types";

export const UsePhoneSetupSetting = () => {
  const baseURL = import.meta.env.VITE_API_URL;

  return useQuery<PhoneSetup, Error>({
    queryKey: ["mobile-setup"],
    queryFn: async () => {
      const token = Cookies.get("token");

      if (!token) {
        throw new Error("No token found");
      }

      const headers = {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      };

      const response = await axios.post<PhoneSetup>(
        `${baseURL}/mobile-setup`,
        {}, // empty body
        { headers }
      );

      return response.data;
    },
    staleTime: Infinity,
  });
};
