import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { Dashboards } from "../../Types/Types";

export const UsegetDashboardData = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<Dashboards, Error>({
        queryKey: ["dashboard-list"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<Dashboards>(
                `${baseURL}/dashboard-list`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
