import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { SocialTypeSetting } from "../../Types/Types";

export const UsegetSocialSetting = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<SocialTypeSetting, Error>({
        queryKey: ["social-media"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const headers = {
                "Content-Type": "application/json",
                Authorization: `Bearer ${token}`,
            };

            const response = await axios.post<SocialTypeSetting>(
                `${baseURL}/social-media`,
                {}, // empty body
                { headers }
            );


            return response.data;
        },
        staleTime: Infinity,
    });
};
