import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface ServiceImage {
  id: number;
  url: string;
}

export interface Vendor {
  id: number;
  first_name: string;
  last_name: string;
  email: string;
  image: string;
  mobile: string;
  username: string;
}

export interface Stores {
  id: number;
  service_name: string;
  category_id: number;
  subcategory_id: string;
  lat: string;
  lon: string;
  employee_strength: string;
  open_days: string;
  closed_days: string | null;
  open_time: string;
  close_time: string;
  created_at: string;
  service_images: ServiceImage[];
  published_month: string;
  published_year: string;
  service_address: string | null;
  category: string;
  is_feature: string;
  service_description:string;
  totalReviewCount: number;
  totalAvgReview: string;
  total_years_count: number;
  total_service_count: number;
  video_url:string;
}

export interface FollowUs {
  instagram_link: string;
  facebook_link: string;
  whatsapp_link: string;
  twitter_link: string;
}

export interface GoalData {
  id: number;
  campaign_id: number;
  start_date: string;
  end_date: string;
  days: string;
  price: string;
  status: number;
  created_at: string;
  updated_at: string;
  campaign_name: string;
  payment_mode: string;
  area_distance:string;
  address:string;
}

export interface Service {
  id: number;
  service_name: string;
  vendor: Vendor;
  stores: Stores;
  follow_us: FollowUs;
  GoalData: GoalData[];
}

export interface AdminStoreView {
  status: boolean;
  message: string;
  service: Service;
}

export interface AdminStoreState {
  data: AdminStoreView | null;
}

const initialState: AdminStoreState = {
  data: null,
};

const adminStoreSlice = createSlice({
  name: "adminStore",
  initialState,
  reducers: {
    setAdminStoreData(state, action: PayloadAction<AdminStoreView>) {
      state.data = action.payload;
    },
    clearAdminStoreData(state) {
      state.data = null;
    },
  },
});

export const { setAdminStoreData, clearAdminStoreData } = adminStoreSlice.actions;
export default adminStoreSlice.reducer;
