// CategoryIconSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const CategoryIconSlice = createSlice({
  name: "CategoryIconSlice",
  initialState,
  reducers: {
    updateCoverImageCategoryIcon(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImageCategoryIcon(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverImageCategoryIcon, clearCoverImageCategoryIcon } = CategoryIconSlice.actions;
export default CategoryIconSlice.reducer;
