import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  selectedCategory: null,
};

const CategorySelectedIDandValues = createSlice({
  name: "category",
  initialState,
  reducers: {

    toggleCategorySelection: (state, action) => {
      if (state.selectedCategory?.id === action.payload.id) {
        state.selectedCategory = null;
      } else {
        state.selectedCategory = action.payload;
      }
    },


    setCategorySelection: (state, action) => {
      state.selectedCategory = action.payload;
    },
    clearSelectedCategory: (state) => {
      state.selectedCategory = null;
    },
  },
});

export const { setCategorySelection, clearSelectedCategory, toggleCategorySelection } =
  CategorySelectedIDandValues.actions;

export default CategorySelectedIDandValues.reducer;



