// CategorySelectedIDandValuesFrontEndStorelist.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface Category {
  id: number;
  service_name: string;
}

interface State {
  selectedCategories: Category[];
}

const initialState: State = {
  selectedCategories: [],
};

const CategorySelectedIDandValuesFrontEndStorelist = createSlice({
  name: "CategorySelectedIDandValuesFrontEndStorelist",
  initialState,
  reducers: {
    toggleCategorySelectionFronEnd: (state, action: PayloadAction<Category>) => {
      const exists = state.selectedCategories.some(cat => cat.id === action.payload.id);
      if (exists) {
        state.selectedCategories = state.selectedCategories.filter(cat => cat.id !== action.payload.id);
      } else {
        state.selectedCategories.push(action.payload);
      }
    },
    clearSelectedCategories: (state) => {
      state.selectedCategories = [];
    },
    setSelectedCategories: (state, action: PayloadAction<Category[]>) => {
      state.selectedCategories = action.payload;
    },
  },
});

export const {
  toggleCategorySelectionFronEnd,
  clearSelectedCategories,
  setSelectedCategories,
} = CategorySelectedIDandValuesFrontEndStorelist.actions;

export default CategorySelectedIDandValuesFrontEndStorelist.reducer;
