import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  selectedCategory: null,
};

const CategorySelectedIDandValuesUpdate = createSlice({
  name: "CategorySelectedIDandValuesUpdate",
  initialState,
  reducers: {
    toggleCategorySelectionUpdate: (state, action) => {
      if (state.selectedCategory?.id === action.payload.id) {
        state.selectedCategory = null;
      } else {
        state.selectedCategory = action.payload;
      }
    },
    clearSelectedCategoryUpdate: (state) => {
      state.selectedCategory = null;
    },
  },
});


export const {
  toggleCategorySelectionUpdate,
  clearSelectedCategoryUpdate,
} = CategorySelectedIDandValuesUpdate.actions;

export default CategorySelectedIDandValuesUpdate.reducer;
