import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  selectedCategory: null,
};

const CategorySelectedIDandValuesUpdateFronentCard3 = createSlice({
  name: "CategorySelectedIDandValuesUpdateFronentCard3",
  initialState,
  reducers: {
    toggleCategorySelectionUpdate3: (state, action) => {
      if (state.selectedCategory?.id === action.payload.id) {
        state.selectedCategory = null;
      } else {
        state.selectedCategory = action.payload;
      }
    },
    clearSelectedCategoryUpdate: (state) => {
      state.selectedCategory = null;
    },
  },
});


export const {
  toggleCategorySelectionUpdate3,
  clearSelectedCategoryUpdate,
} = CategorySelectedIDandValuesUpdateFronentCard3.actions;

export default CategorySelectedIDandValuesUpdateFronentCard3.reducer;
