import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface ModalState {
    Admin_Block_Modal: boolean;
    Gift_Image_Modal: boolean;
    Add_Gift_Modal: boolean;
    Update_Gift_Modal: boolean;
    Log_Out_Modal: boolean;
    ReelDetail_Modal?: boolean;
    CommentLike_List_Modal?: boolean;
    Following_Modal?: boolean;
    Follower_Modal?: boolean;
    AvatarUpload_Modal?: boolean;
    AvatarUpdate_Modal: boolean;
    UpdateLanguage_Modal: boolean;
    AddLanguage_Modal: boolean;
    AddGiftCategory: boolean;
    MusicDelete_Modal: boolean;
    MusicUpdate_Modal: boolean;
    MusicAdd_Modal: boolean;
    MusicShow_Modal?: boolean;
    UploadMusicModalWithS3: boolean;
    AddCategoryModal: boolean;
    AddSubCategoryModal: boolean;
    CategoryDeleteModal: boolean;
    CategoryUpdateModal: boolean;
    UpdateSubCategoryModal: boolean;
    SubCategoryDeleteModal: boolean;
    CategoryListValuesShowModal: boolean;
    SubcriptionPlanlListAddModal: boolean;
    SubscriptionPlanDeleteModal: boolean;
    SubscriptionPlanUpdateModal: boolean;
    ServiceDeleteModal: boolean;
    StooreDeleteModal: boolean;
    AddFAQModal: boolean;
    UpdateFAQModal: boolean;
    DeleteUpdateFAQModal: boolean;
    AddReportTextModal: boolean;
    DeleteReporModal: boolean;
    AddClientReviewModal: boolean;
    DeleteClientModal: boolean;
    AddCurrencyModal: boolean;
    DeleteCurrencyModal: boolean;
    DeleteCustomerSuportModal: boolean;
    AddSliderModal: boolean;
    DeleteSliderModal: boolean;
    DeleteReviewModal:boolean;
    UpdateReviewModal:boolean;
    UpdateSliderModal:boolean;
    DeleteToken:boolean;
    DeleteReviewViewStore:boolean;


}

const initialState: ModalState = {
    Admin_Block_Modal: false,
    Gift_Image_Modal: false,
    Add_Gift_Modal: false,
    Update_Gift_Modal: false,
    Log_Out_Modal: false,
    ReelDetail_Modal: false,
    CommentLike_List_Modal: false,
    Following_Modal: false,
    Follower_Modal: false,
    AvatarUpload_Modal: false,
    AvatarUpdate_Modal: false,
    UpdateLanguage_Modal: false,
    AddLanguage_Modal: false,
    AddGiftCategory: false,
    MusicDelete_Modal: false,
    MusicUpdate_Modal: false,
    MusicAdd_Modal: false,
    MusicShow_Modal: false,
    UploadMusicModalWithS3: false,
    AddCategoryModal: false,
    AddSubCategoryModal: false,
    CategoryDeleteModal: false,
    CategoryUpdateModal: false,
    UpdateSubCategoryModal: false,
    SubCategoryDeleteModal: false,
    CategoryListValuesShowModal: false,
    SubcriptionPlanlListAddModal: false,
    SubscriptionPlanDeleteModal: false,
    SubscriptionPlanUpdateModal: false,
    ServiceDeleteModal: false,
    StooreDeleteModal: false,
    AddFAQModal: false,
    UpdateFAQModal: false,
    DeleteUpdateFAQModal: false,
    AddReportTextModal: false,
    DeleteReporModal: false,
    AddClientReviewModal: false,
    DeleteClientModal: false,
    AddCurrencyModal: false,
    DeleteCurrencyModal: false,
    DeleteCustomerSuportModal: false,
    AddSliderModal: false,
    DeleteSliderModal: false,
    DeleteReviewModal:false,
    UpdateReviewModal:false,
    DeleteToken:false,
    UpdateSliderModal:false,
    DeleteReviewViewStore:false,
};

const ModalSlice = createSlice({
    name: "modals",
    initialState,
    reducers: {
        showModal: (state, action: PayloadAction<keyof ModalState>) => {
            state[action.payload] = true;
        },
        hideModal: (state, action: PayloadAction<keyof ModalState>) => {
            state[action.payload] = false;
        },
    },
});

export const { showModal, hideModal } = ModalSlice.actions;

// cheack any modal opne and close

export const selectAnyModalOpen = (state: { modals: ModalState }) => {
    return Object.values(state.modals).includes(true);
};
export default ModalSlice.reducer;
