// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const SeoSlice = createSlice({
  name: "SeoSlice",
  initialState,
  reducers: {
    SeoImageUpdate(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImageSeo(state) {
      state.cover_image = null;
    },
  },
});

export const { SeoImageUpdate, clearCoverImageSeo } = SeoSlice.actions;
export default SeoSlice.reducer;
