import { createSlice } from '@reduxjs/toolkit'
import type { PayloadAction } from '@reduxjs/toolkit'


interface ServiceImage {
  id: number
  service_images: string
}

interface Service {
  id: number
  vendor_id: number
  category_id: number
  subcategory_id: string
  service_name: string
  service_description: string
  service_website: string
  service_country_code: string
  service_phone: string
  service_email: string
  address: string
  lat: string
  lon: string
  area: string
  city: string
  state: string
  country: string
  status: number
  open_days: string
  closed_days: string
  open_time: string
  close_time: string
  is_featured: string
  instagram_link: string
  facebook_link: string
  whatsapp_link: string
  twitter_link: string
  video_thumbnail: string
  video: string
  video_url: string
  cover_image: string
  aspect_ratio: string
  employee_strength: string
  published_month: string
  published_year: string
  request_approval: number
  meta_title: string
  meta_description: string
  notify_count: number
  service_address: string
  created_at: string
  updated_at: string
}

interface ServiceState {
  service: Service | null
  service_images: ServiceImage[]
  cover_image: string
  video_thumbnail: string
  video: string
}

const initialState: ServiceState = {
  service: null,
  service_images: [],
  cover_image: '',
  video_thumbnail: '',
  video: '',
}

const serviceSlice = createSlice({
  name: 'service',
  initialState,
  reducers: {
    updateStoreValues(state, action: PayloadAction<ServiceState>) {
      state.service = action.payload.service
      state.service_images = action.payload.service_images
      state.cover_image = action.payload.cover_image
      state.video_thumbnail = action.payload.video_thumbnail
      state.video = action.payload.video
    },
    clearService(state) {
      state.service = null
      state.service_images = []
      state.cover_image = ''
      state.video_thumbnail = ''
      state.video = ''
    },
    updateServiceField(state, action: PayloadAction<{ key: keyof Service; value: string }>) {
      if (state.service) {
        (state.service as any)[action.payload.key] = action.payload.value
      }
    },


  },
})

export const { updateStoreValues, clearService  , updateServiceField} = serviceSlice.actions
export default serviceSlice.reducer
