import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

interface OpenDayState {
  selectedDays: string[];
}

const initialState: OpenDayState = {
  selectedDays: [],
};

const OpenDaySlice = createSlice({
  name: 'openDay',
  initialState,
  reducers: {
    toggleDaySelection: (state, action: PayloadAction<string>) => {
      const day = action.payload;
      if (state.selectedDays.includes(day)) {
        state.selectedDays = state.selectedDays.filter((d) => d !== day);
      } else {
        state.selectedDays.push(day);
      }
    },
    removeDay: (state, action: PayloadAction<string>) => {
      state.selectedDays = state.selectedDays.filter((day) => day !== action.payload);
    },
    resetDays: (state) => {
      state.selectedDays = [];
    },
    setSelectedDays: (state, action: PayloadAction<string[]>) => {
      state.selectedDays = action.payload;
    },
  },
});

export const { toggleDaySelection, removeDay, resetDays, setSelectedDays } = OpenDaySlice.actions;
export default OpenDaySlice.reducer;

