import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
    service_description?: string;
}

const initialState: AddPostStateType = {
    service_description: "",
};

const StoreaddDescription = createSlice({
    name: "StoreaddDescription",
    initialState,
    reducers: {
        StoreaddDescriptionState(state, action: PayloadAction<Partial<AddPostStateType>>) {
            return { ...state, ...action.payload };
        },
         clearall() {
            return initialState;
        },
    },
});

export default StoreaddDescription.reducer;
export const { StoreaddDescriptionState , clearall } = StoreaddDescription.actions;
