import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

interface Category {
    id: number;
    subcategory_name: string;
    subcategory_image: string;
    category_id: string;
}

interface CategoryUpdateState {
    category: Category | null;
}

const initialState: CategoryUpdateState = {
    category: null,
};

const SubCategoryUpdateSlice = createSlice({
    name: 'SubCategoryUpdateSlice',
    initialState,
    reducers: {
        setSubCategoryUpdate(state, action: PayloadAction<CategoryUpdateState>) {
            state.category = action.payload.category;
        },
        clearCategoryUpdate(state) {
            state.category = null;
        }
    },
});

export const { setSubCategoryUpdate, clearCategoryUpdate } = SubCategoryUpdateSlice.actions;

export default SubCategoryUpdateSlice.reducer;
