// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const UpdateCategoryIconSlice = createSlice({
  name: "UpdateCategoryIconSlice",
  initialState,
  reducers: {
    updateCoverCategoryIcon(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImageIcon(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverCategoryIcon, clearCoverImageIcon } = UpdateCategoryIconSlice.actions;
export default UpdateCategoryIconSlice.reducer;
