// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const UpdateCategoryImageSliceFrontend4 = createSlice({
  name: "UpdateCategoryImageSliceFrontend4",
  initialState,
  reducers: {
    updateCoverImageCategoryFrontend4(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImage(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverImageCategoryFrontend4, clearCoverImage } = UpdateCategoryImageSliceFrontend4.actions;
export default UpdateCategoryImageSliceFrontend4.reducer;
