// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const UpdateSlideSlice = createSlice({
  name: "UpdateSlideSlice",
  initialState,
  reducers: {
    updateSliderImage(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoversliderImage(state) {
      state.cover_image = null;
    },
  },
});

export const { updateSliderImage, clearCoversliderImage } = UpdateSlideSlice.actions;
export default UpdateSlideSlice.reducer;
