// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
    cover_image: File | null;
}

const initialState: AddPostStateType = {
    cover_image: null,
};

const UploadServiceAttactmentSlice = createSlice({
    name: "UploadServiceAttactmentSlice",
    initialState,
    reducers: {
        updateAddserviceAttactmentImage(state, action: PayloadAction<File | null>) {
            state.cover_image = action.payload;
        },
        clearCoverImageatc(state) {
            state.cover_image = null;
        },
    },
});

export const { updateAddserviceAttactmentImage, clearCoverImageatc } = UploadServiceAttactmentSlice.actions;
export default UploadServiceAttactmentSlice.reducer;
