// Appstore/Slice/VendorSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface Vendor {
    id: number;
    first_name: string;
    last_name: string;
    username: string;
    email: string;
    mobile: string;
    image: string;
    status: number;
    created_at: string;
}

interface VendorState {
    vendors: Vendor[];
    selectedVendor: Vendor | null;
}

const initialState: VendorState = {
    vendors: [],
    selectedVendor: null,
};

export const vendorSlice = createSlice({
    name: "vendor",
    initialState,
    reducers: {
        setVendorList: (state, action: PayloadAction<Vendor[]>) => {
            state.vendors = action.payload;
        },
        selectVendor: (state, action: PayloadAction<Vendor | null>) => {
            state.selectedVendor = action.payload;
        },

        clearVendordetail() {
            return initialState;
        },
    },
});

export const { setVendorList, selectVendor , clearVendordetail } = vendorSlice.actions;
export default vendorSlice.reducer;
