import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';
import type { PaymentSetting } from '../../Types/Types';

interface AppConfigState {
  config: PaymentSetting | null;
  loading: boolean;
  error: string | null;
}

const initialState: AppConfigState = {
  config: null,
  loading: false,
  error: null,
};

const appConfigSlice = createSlice({
  name: 'appConfig',
  initialState,
  reducers: {
    setAppConfig(state, action: PayloadAction<PaymentSetting>) {
      state.config = action.payload;
      state.loading = false;
      state.error = null;
    },
  },
});

export const {
  setAppConfig,
} = appConfigSlice.actions;

export default appConfigSlice.reducer;
