import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface IndexCardState {
  id: number | null;
  title: string;
  image: string;
  category_id: string;
}

const initialState: IndexCardState = {
  id: null,
  title: "",
  image: "",
  category_id: "",
};

const indexCardSlice3 = createSlice({
  name: "indexCardSlice3",
  initialState,
  reducers: {
    setIndexCardData3(state, action: PayloadAction<IndexCardState>) {
      state.id = action.payload.id;
      state.title = action.payload.title;
      state.image = action.payload.image;
      state.category_id = action.payload.category_id;
    },
    clearIndexCardData(state) {
      state.id = null;
      state.title = "";
      state.image = "";
      state.category_id = "";
    },
  },
});

export const { setIndexCardData3, clearIndexCardData } = indexCardSlice3.actions;

export default indexCardSlice3.reducer;
