// store/languageSlice.ts
import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

export interface Language {
  language: string;
  status: number;
  default_status: number;
  status_id: number;
  country: string;
  language_alignment?: 'ltr' | 'rtl';
}

interface LanguageState {
  selectedLanguage: Language;
}

const initialState: LanguageState = {
  selectedLanguage: {
    language: 'English',
    status: 1,
    default_status: 1,
    status_id: 1,
    country: 'US',
    language_alignment: 'ltr',
  },
};

const languageSlice = createSlice({
  name: 'language',
  initialState,
  reducers: {
    setSelectedLanguage(state, action: PayloadAction<Language>) {
      state.selectedLanguage = action.payload;
    },
  },
});

export const { setSelectedLanguage } = languageSlice.actions;
export default languageSlice.reducer;
