// src/Appstore/Slice/sliderSlice.ts

import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

interface SliderItem {
  id: number;
  description: string;
  status: number;
  image: string;
  created_at: string;
}

const initialState: SliderItem = {
  id: 0,
  description: '',
  status: 0,
  image: '',
  created_at: '',
};

const sliderSlice = createSlice({
  name: 'slider',
  initialState,
  reducers: {
    setSlider(state, action: PayloadAction<SliderItem>) {
      return { ...state, ...action.payload };
    },
    updateSliderImage(state, action: PayloadAction<string>) {
      state.image = action.payload;
    },
    updateSliderStatus(state, action: PayloadAction<number>) {
      state.status = action.payload;
    },
    updateSliderDescription(state, action: PayloadAction<string>) {
      state.description = action.payload;
    },
    resetSlider() {
      return initialState;
    },
  },
});

export const {
  setSlider,
  updateSliderImage,
  updateSliderStatus,
  updateSliderDescription,
  resetSlider,
} = sliderSlice.actions;

export default sliderSlice.reducer;
