import { createSlice} from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";


interface StoreItem {
  id: number;
  service_name: string;
}

interface StoreState {
  selectedStores: StoreItem[];
}

const initialState: StoreState = {
  selectedStores: [],
};

const storennameslicemultiple = createSlice({
  name: "storennameslicemultiple",
  initialState,
  reducers: {
    toggleStoreSelection: (state, action: PayloadAction<StoreItem>) => {
      const exists = state.selectedStores.find(
        (store) => store.id === action.payload.id
      );

      if (exists) {
        state.selectedStores = state.selectedStores.filter(
          (store) => store.id !== action.payload.id
        );
      } else {
        state.selectedStores.push(action.payload);
      }
    },
    removeStore: (state, action: PayloadAction<number>) => {
      state.selectedStores = state.selectedStores.filter(
        (store) => store.id !== action.payload
      );
    },
    clearAllStores: (state) => {
      state.selectedStores = [];
    },
  },
});

export const {
  toggleStoreSelection,
  removeStore,
  clearAllStores,
} = storennameslicemultiple.actions;

export default storennameslicemultiple.reducer;
