import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

interface VendorData {
  id: number;
  email: string;
  expire_date: string;
  image: string;
  payment_mode: string;
  plan_name: string;
  price: string;
  start_date: string;
  status: number;
  user_id: string;
  vendor_name: string;
  created_at: string;
}

interface SubscribedVendorState {
  selectedVendor: VendorData | null;
}

const initialState: SubscribedVendorState = {
  selectedVendor: null,
};

const subscribedVendorSlice = createSlice({
  name: 'subscribedVendor',
  initialState,
  reducers: {
    setSelectedVendor(state, action: PayloadAction<VendorData>) {
      state.selectedVendor = action.payload;
    },
    clearSelectedVendor(state) {
      state.selectedVendor = null;
    },
  },
});

export const { setSelectedVendor, clearSelectedVendor } = subscribedVendorSlice.actions;
export default subscribedVendorSlice.reducer;
