import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { NlyticalCOngiguration } from "../Types/Types";

export const UseConfigration = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<NlyticalCOngiguration, Error>({
        queryKey: ["admin_all_login_status"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const headers = {
                "Content-Type": "application/json",
                Authorization: `Bearer ${token}`,
            };

            const response = await axios.post<NlyticalCOngiguration>(
                `${baseURL}/admin_all_login_status`,
                {}, // empty body
                { headers }
            );


            return response.data;
        },
        staleTime: Infinity,
    });
};
