import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useState } from "react";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { hideModal } from "../../Appstore/Slice/ModalSlice";
import { setTrue } from "../../Appstore/Slice/toggleSlice";
import ModalHeader from "./ModalHeader";

function AddReportTextModal() {
  const isOpen = useAppSelector((state) => state.modals.AddReportTextModal);
  const dispatch = useAppDispatch();

  const [question, setQuestion] = useState("");
  const { postData, loading } = useApiPost();

  const close = () => dispatch(hideModal("AddReportTextModal"));

  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const handleSubmit = async () => {


    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }
    if (!question) {
      toast.error("Please fill all required fields");
      return;
    }

    const formData = new FormData();
    formData.append("text", question);

    try {
      await postData("/add-reporttext", formData, true);
      toast.success("FAQ added successfully");
      close();
      dispatch(setTrue());
    } catch (error) {
      toast.error("Something went wrong");
    }
  };

  return (
    <Dialog open={isOpen} onClose={close} as="div" className="z-50">
      <div className="fixed inset-0 z-10 overflow-y-auto bg-black/55 backdrop-blur-sm">
        <div className="flex min-h-full items-center justify-center p-4">
          <DialogPanel className="mx-auto w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] h-fit border border-bordercolor rounded-2xl bg-primary shadow-lg backdrop-blur-2xl duration-300 ease-out">
            <ModalHeader title="Add Report Text" onClose={close} />

            <div className="w-full grid gap-4 px-4 pb-5 mt-6">
              {/* Question Input */}
              <div className="flex flex-col gap-2">
                <label className="font-poppins text-sm font-medium text-textcolor">
                  Report Text<span className="text-[#F21818]">*</span>
                </label>
                <input
                  type="text"
                  value={question}
                  onChange={(e) => setQuestion(e.target.value)}
                  placeholder="Enter question"
                  className="w-full rounded-lg border border-bordercolor bg-primary text-textcolor px-4 py-2.5 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none focus:ring-1 focus:ring-header"
                />
              </div>



              {/* Submit Button */}
              <div className="flex justify-center">
                <button
                  disabled={loading}
                  onClick={handleSubmit}
                  className="px-10 py-2    cursor-pointer rounded-xl bggradient font-poppins text-white disabled:opacity-50"
                >
                  {loading ? "Submitting..." : "Submit"}
                </button>
              </div>
            </div>
          </DialogPanel>
        </div>
      </div>
    </Dialog>
  );
}

export default AddReportTextModal;
