import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import { hideModal } from "../../Appstore/Slice/ModalSlice";
import useApiPost from "../../Hooks/PostData";
import { setTrue } from "../../Appstore/Slice/toggleSlice";
import ModalHeader from "./ModalHeader";

function DeleteReviewModal() {
    const isOpen = useAppSelector((state) => state.modals.DeleteReviewModal);
    const dispatch = useAppDispatch();
    const { postData, loading } = useApiPost();

    const closeModal = () => dispatch(hideModal("DeleteReviewModal"));


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleDelete = async () => {

        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const id = sessionStorage.getItem("DeleteReviewID");

        if (!id) {
            toast.error("No category ID found.");
            return;
        }

        const formData = new FormData();
        formData.append("id", id);

        try {
            await postData("/delete-review", formData, true);
            toast.success("Slider deleted successfully.");
            dispatch(setTrue());
            closeModal();
        } catch (error) {
            toast.error("Something went wrong while deleting.");
        }
    };

    return (
        <Dialog open={isOpen} onClose={closeModal} className="z-50">
            <div className="fixed inset-0 z-10 overflow-y-auto bg-black/55 backdrop-blur-sm">
                <div className="flex min-h-full items-center justify-center p-4">
                    <DialogPanel className="mx-auto w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] border border-bordercolor rounded-2xl bg-primary shadow-lg backdrop-blur-2xl">
                        <ModalHeader title="Delete Reviews" onClose={closeModal} />

                        <div className=" flex flex-col  gap-4  h-fit  py-4  md:py-0 md:h-[10rem]  justify-center  items-center">
                            <h2 className="text-center  font-poppins text-xl font-medium text-textcolor mb-6">
                                Are you sure you want to delete this Reviews ?
                            </h2>

                            <div className="flex flex-col sm:flex-row justify-center gap-4">
                                <button
                                    onClick={closeModal}
                                    className="w-full sm:w-auto px-20  cursor-pointer py-2 border border-header rounded-lg text-[#3A3333] font-medium transition hover:bg-gray-100"
                                    disabled={loading}
                                >
                                    Cancel
                                </button>
                                <button
                                    onClick={handleDelete}
                                    className="w-full sm:w-auto px-20 py-2 cursor-pointer rounded-lg text-white bggradient font-medium transition hover:opacity-90"
                                    disabled={loading}
                                >
                                    {loading ? "Deleting..." : "Delete"}
                                </button>
                            </div>
                        </div>
                    </DialogPanel>
                </div>
            </div>
        </Dialog>
    );
}

export default DeleteReviewModal;
