import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useEffect, useState } from "react";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { hideModal } from "../../Appstore/Slice/ModalSlice";
import ModalHeader from "./ModalHeader";
import { setTrue } from "../../Appstore/Slice/toggleSlice";

function UpdateReviewModal() {
    const isOpen = useAppSelector((state) => state.modals.UpdateReviewModal);
    const dispatch = useAppDispatch();
    const { postData, loading, data } = useApiPost();
    const SubscriptionUpdateId = sessionStorage.getItem("UpdateReviewID");

    const [subText, setSubText] = useState("");

    // Fetch existing review data
    useEffect(() => {
        if (SubscriptionUpdateId) {
            const formdata1 = new FormData();
            formdata1.append("id", SubscriptionUpdateId);
            postData("/update-review", formdata1, false); // `false` here means GET-like usage
        }
    }, [SubscriptionUpdateId]);

    // Update text area when data is fetched
    useEffect(() => {
        if (data?.admindetails?.review_message) {
            setSubText(data.admindetails.review_message);
        }
    }, [data]);

    const close = () => dispatch(hideModal("UpdateReviewModal"));


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleSubmit = async () => {

        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        if (!subText) {
            toast.error("Please fill all required fields");
            return;
        }

        const formData = new FormData();
        formData.append("id", SubscriptionUpdateId || "");
        formData.append("review_message", subText);

        try {
            await postData("/update-review", formData, true); // `true` = POST request
            toast.success("Review updated successfully");
            dispatch(setTrue());
            close();

        } catch (error) {
            toast.error("Something went wrong");
        }
    };

    return (
        <Dialog open={isOpen} onClose={close} as="div" className="z-50">
            <div className="fixed inset-0 z-10 overflow-y-auto bg-black/55 backdrop-blur-sm">
                <div className="flex min-h-full items-center justify-center p-4">
                    <DialogPanel className="mx-auto w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] rounded-2xl border border-bordercolor bg-primary shadow-lg backdrop-blur-2xl">
                        <ModalHeader title="Update Reviews" onClose={close} />
                        <div className="w-full grid gap-3 px-4 pb-4 mt-8">
                            {/* Review Textarea */}
                            <div className="flex flex-col gap-2">
                                <label className="font-poppins text-sm font-medium text-textcolor">
                                    Review <span className="text-[#F21818]">*</span>
                                </label>
                                <textarea
                                    rows={3}
                                    value={subText}
                                    onChange={(e) => setSubText(e.target.value)}
                                    placeholder="Enter review"
                                    className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 placeholder:text-placeholdercolor text-textcolor placeholder:text-sm resize-none focus:outline-none focus:ring-1 focus:ring-header"
                                />
                            </div>

                            {/* Submit Button */}
                            <div className="flex justify-center">
                                <button
                                    onClick={handleSubmit}
                                    disabled={loading}
                                    className="px-10 py-2 rounded-xl cursor-pointer bggradient font-poppins text-white disabled:opacity-50"
                                >
                                    {loading ? "Submitting..." : "Submit"}
                                </button>
                            </div>
                        </div>
                    </DialogPanel>
                </div>
            </div>
        </Dialog>
    );
}

export default UpdateReviewModal;
