import React from 'react';

interface StoryThumbnailProps {
  url: string;
  storyId: number | string;
  onClick: (storyId: number | string) => void;
}

const StoryThumbnail: React.FC<StoryThumbnailProps> = ({ url, storyId, onClick }) => {
  
  return (
    <div
      className=" w-full cursor-pointer"
      onClick={() => onClick(storyId)}
    >
      <img
        src={url}
        className="object-cover rounded-lg w-14 h-14"
        alt="Story thumbnail"
      />
    </div>
  );
};

export default StoryThumbnail;
