import { useEffect, useState } from "react";

const GOOGLE_MAPS_API_KEY = "AIzaSyAMZ4GbRFYSevy7tMaiH5s0JmMBBXc0qBA";

export function useGoogleMaps() {
  const [loaded, setLoaded] = useState(false);

  useEffect(() => {
    if (typeof window.google !== "undefined" && window.google.maps) {
      setLoaded(true);
      return;
    }

    const existingScript = document.getElementById("google-maps-script");
    if (!existingScript) {
      const script = document.createElement("script");
      script.id = "google-maps-script";
      script.src = `https://maps.googleapis.com/maps/api/js?key=${GOOGLE_MAPS_API_KEY}&libraries=places`;
      script.async = true;
      script.defer = true;
      script.onload = () => {
        setLoaded(true);
      };
      document.body.appendChild(script);
    } else {
      existingScript.addEventListener("load", () => setLoaded(true));
    }
  }, []);

  return loaded;
}
