import React, { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';
import { Link, useLocation, useNavigate } from 'react-router-dom';
import toast from 'react-hot-toast';

import SearchBar from '../../Componets/SearchBar/SearchBar';
import FormGlobalINputNlytical from '../../Componets/Form/FormGlobalINputNlytical';
import CategoryDropdown from './StoreDropdwon';
import AddServiceImage from './AddsericeImage';
import ServiceAttachment from './ServiceAttachment';

import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import useApiPost from '../../Hooks/PostData';
import AddServiceDecsription from './AddServiceDecsription';
import { clearall12 } from '../../Appstore/Slice/AddSubcriptionDescription';
import { clearSelectedCategory } from '../../Appstore/Slice/CategorySelectedIDandValues';
import { clearCoverImageatc } from '../../Appstore/Slice/UploadServiceAttactmentSlice';
import { clearAllCoverImages } from '../../Appstore/Slice/UploadAddserviceImageSlice';
import { setTrue } from '../../Appstore/Slice/toggleSlice';
import TextEditeNewVersion from './TextEditeNewVersion';
import { clearAllStores } from '../../Appstore/Slice/storennameslicemultiple';
import { MdArrowBack } from 'react-icons/md';

function AddService() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const navigate = useNavigate();
    const location = useLocation();
    const currentPath = location.pathname.split('/');
    const sourcePage = currentPath[1] || 'user-list';





    //  when page load then dispatch(clearAllStores()) rese6t 


    useEffect(() => {
        dispatch(clearAllStores());
    }, []);



    const dispatch = useAppDispatch()

    const { loading, postData } = useApiPost();
    const coverImage = useAppSelector((state) => state.UploadAddserviceImageSlice);
    console.log("coverImagecoverImagecoverImagecoverImagemonu", coverImage)
    const attachment = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);

    const [formData, setFormData] = useState({
        serviceName: '',
        price: '',
    });

    const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
        const { name, value } = e.target;
        setFormData((prev) => ({ ...prev, [name]: value }));
    };


    const { service_description } = useAppSelector((state) => state.AddSubcriptionDescription)


    console.log("service_descriptionservice_descriptionmonu", service_description)
    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const selectedStores = useAppSelector(
        (state) => state.storennameslicemultiple.selectedStores
    );


    console.log("selectedStoresselectedStoresselectedStores", selectedStores)


    const handleUploadService = async () => {
        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }

        const { serviceName, price } = formData;

        if (
            !serviceName ||
            !service_description ||
            !price ||
            !coverImage?.cover_images?.length ||
            !selectedStores.length // ✅ Check if stores are selected
        ) {
            toast.error('All fields are required.');
            return;
        }

        const data = new FormData();
        data.append('store_name', serviceName);
        data.append('store_description', service_description);
        data.append('price', price);

        const storeIds = selectedStores.map((store) => store.id).join(',');
        data.append('service_id', storeIds);

        // ✅ Append images
        coverImage.cover_images.forEach((file: File) => {
            data.append('store_images[]', file);
        });

        // ✅ Append attachments
        data.append('store_attachments[]', attachment);

        try {
            const result = await postData('/add-store', data, 'multipart/form-data');
            toast.success('Service uploaded successfully!');
            dispatch(clearall12());
            dispatch(clearSelectedCategory());
            dispatch(clearAllCoverImages());
            dispatch(clearCoverImageatc());
            dispatch(clearAllStores())
            navigate("/service-list");
            dispatch(setTrue());
        } catch (error) {
            toast.error('Failed to upload service.');
            console.error(error);
        }
    };


    return (
        <div className={`bg-primary ${isSidebarOpen ? 'xl:pl-20' : 'xl:pl-72'}`}>
            <SearchBar />

            <div className="px-4 xl:px-6">
                <div className="w-full flex justify-between items-center gap-2">
                    {/* Left Content */}
                    <div className="flex flex-col">
                        {/* Header */}
                        <div className="flex justify-between border-t-[#F2F2F2] py-3">
                            <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                                Add Service
                            </h2>
                        </div>

                        {/* Breadcrumb */}
                        <div className="mb-4 flex items-center gap-2">
                            <Link to="/dashboard">
                                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                                    Dashboard
                                </h3>
                            </Link>
                            <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                            <h3 className="text-base text-[#858585] font-poppins">Add Service</h3>
                        </div>
                    </div>

                    {/* Back Button */}
                    <button
                        onClick={() => navigate(-1)} // go back
                        className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
                    >
                        <MdArrowBack size={20} />
                        Back
                    </button>
                </div>
            </div>


            {/* Main Form */}
            <div className="mx-auto w-[97%] border border-bordercolor mt-12 rounded-lg p-4">




                <div className=' w-full flex  flex-col gap-4'>
                    <div className=' w-full   grid  md:grid-cols-2  xl:grid-cols-3 gap-4 '>
                        <FormGlobalINputNlytical
                            label="Service Name"
                            name="serviceName"
                            value={formData.serviceName}
                            onChange={handleChange}
                            required={true}
                            placeholder="Enter Service Name"

                        />
                        <FormGlobalINputNlytical
                            label="Service Price"
                            name="price"
                            value={formData.price}
                            onChange={handleChange}
                            required
                            placeholder="Enter Service Price"
                        />
                        <CategoryDropdown />

                    </div>


                    <div className=' w-full'>
                        {/* <AddServiceDecsription /> */}
                        <TextEditeNewVersion />
                    </div>

                    <div className=' w-full grid   md:grid-cols-2 gap-4'>
                        <AddServiceImage />
                        <ServiceAttachment />
                    </div>
                </div>



                {/* Submit Button */}
                <div className="w-full flex justify-center mt-6">
                    <button
                        onClick={handleUploadService}
                        disabled={loading}
                        className="text-white font-poppins bggradient px-16 py-2 rounded-lg cursor-pointer"
                    >
                        {loading ? 'Submitting...' : 'Submit'}
                    </button>
                </div>
            </div>
        </div>
    );
}

export default AddService;
