import React, { useState, useRef, useMemo } from "react";
import { useDispatch } from "react-redux";
import JoditEditor from "jodit-react";
import { useAppSelector } from "../../Hooks/Hooks";
import { updateSubplanData } from "../../Appstore/Slice/AddSubcriptionDescription";

const AddServiceDecsription = () => {
    const dispatch = useDispatch();
    const editor = useRef(null);
    const [content, setContent] = useState("");

    const { service_description } = useAppSelector((state) => state.AddSubcriptionDescription)

    const config = useMemo(
        () => ({
            readonly: false,
            placeholder: "Service description typing..." || "Service description typing...",
            toolbar: true,
            buttons: [
                "bold",
                "italic",
                "underline",
                "strike",
                "|",
                "font",
                "fontsize",
                "forecolor",
                "backcolor",
                "|",
                "ul",
                "ol",
                "outdent",
                "indent",
                "|",
                "align",
                "alignleft",
                "aligncenter",
                "alignright",
                "alignjustify",
                "|",
                "link",
                "image",
                "table",
                "video",
                "|",
                "undo",
                "redo",
                "removeformat",
                "clear",
                "|",
                "fullsize",
            ],
            spellcheck: true,
            showCharsCounter: false,
            showWordsCounter: false,
            height: 400,

            // 👇 This line disables the paste HTML popup
            askBeforePasteHTML: false,

            // Optional: Also clean inline styles from pasted content
            cleanHTML: {
                removeStyles: true,
                removeTags: ["style", "script"],
            },
        }),
        []
    );

    const handleContentChange = (newContent: string) => {
        setContent(newContent);
        dispatch(updateSubplanData({ service_description: newContent }));
    };

    return (
        <div className=" w-full  overflow-hidden">
            <label
                className="block text-sm font-medium font-poppins text-[#000000]"
                htmlFor="businessDescription"
            >
                Business Description<span className="text-[#FF0000]"> *</span>
            </label>
            <div className="mt-2">
                <JoditEditor
                    ref={editor}
                    value={service_description}
                    config={config}
                    tabIndex={1}
                    onBlur={(newContent) => handleContentChange(newContent)}
                    onChange={(newContent) => handleContentChange(newContent)}
                />
            </div>
        </div>
    );
};

export default AddServiceDecsription;
